/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.internal.LocalizationMessages;

public class JerseyClientBuilder
extends ClientBuilder {
    private final ClientConfig config = new ClientConfig();
    private HostnameVerifier hostnameVerifier;
    private SslConfigurator sslConfigurator;
    private SSLContext sslContext;

    public JerseyClientBuilder sslContext(SSLContext sslContext) {
        if (sslContext == null) {
            throw new NullPointerException(LocalizationMessages.NULL_SSL_CONTEXT());
        }
        this.sslContext = sslContext;
        this.sslConfigurator = null;
        return this;
    }

    public JerseyClientBuilder keyStore(KeyStore keyStore, char[] password) {
        if (keyStore == null) {
            throw new NullPointerException(LocalizationMessages.NULL_KEYSTORE());
        }
        if (password == null) {
            throw new NullPointerException(LocalizationMessages.NULL_KEYSTORE_PASWORD());
        }
        if (this.sslConfigurator == null) {
            this.sslConfigurator = SslConfigurator.newInstance();
        }
        this.sslConfigurator.keyStore(keyStore);
        this.sslConfigurator.keyPassword(password);
        this.sslContext = null;
        return this;
    }

    public JerseyClientBuilder trustStore(KeyStore trustStore) {
        if (trustStore == null) {
            throw new NullPointerException(LocalizationMessages.NULL_TRUSTSTORE());
        }
        if (this.sslConfigurator == null) {
            this.sslConfigurator = SslConfigurator.newInstance();
        }
        this.sslConfigurator.trustStore(trustStore);
        this.sslContext = null;
        return this;
    }

    public JerseyClientBuilder hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public JerseyClient build() {
        SSLContext ctx = this.sslContext;
        if (ctx == null) {
            ctx = this.sslConfigurator != null ? this.sslConfigurator.createSSLContext() : SslConfigurator.getDefaultContext();
        }
        return new JerseyClient(this.config, ctx, this.hostnameVerifier);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public JerseyClientBuilder property(String name, Object value) {
        this.config.property(name, value);
        return this;
    }

    public JerseyClientBuilder register(Class<?> componentClass) {
        this.config.register((Class)componentClass);
        return this;
    }

    public JerseyClientBuilder register(Class<?> componentClass, int priority) {
        this.config.register((Class)componentClass, priority);
        return this;
    }

    public JerseyClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.config.register((Class)componentClass, (Class[])contracts);
        return this;
    }

    public JerseyClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.config.register((Class)componentClass, (Map)contracts);
        return this;
    }

    public JerseyClientBuilder register(Object component) {
        this.config.register(component);
        return this;
    }

    public JerseyClientBuilder register(Object component, int priority) {
        this.config.register(component, priority);
        return this;
    }

    public JerseyClientBuilder register(Object component, Class<?> ... contracts) {
        this.config.register(component, (Class[])contracts);
        return this;
    }

    public JerseyClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.config.register(component, (Map)contracts);
        return this;
    }

    public JerseyClientBuilder withConfig(Configuration config) {
        this.config.loadFrom(config);
        return this;
    }
}

