/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyInvocation;
import org.glassfish.jersey.client.JerseyWebTarget;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.UnsafeValue;
import org.glassfish.jersey.internal.util.collection.Values;

public class JerseyClient
implements Client {
    private static final Logger LOGGER = Logger.getLogger(JerseyClient.class.getName());
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final ClientConfig config;
    private final HostnameVerifier hostnameVerifier;
    private final UnsafeValue<SSLContext, IllegalStateException> sslContext;
    private final LinkedBlockingDeque<LifecycleListener> listeners = new LinkedBlockingDeque();

    protected JerseyClient() {
        this(null, (UnsafeValue<SSLContext, IllegalStateException>)((UnsafeValue)null), null);
    }

    protected JerseyClient(Configuration config, SSLContext sslContext, HostnameVerifier verifier) {
        this(config, (UnsafeValue<SSLContext, IllegalStateException>)Values.unsafe((Object)sslContext), verifier);
    }

    protected JerseyClient(Configuration config, UnsafeValue<SSLContext, IllegalStateException> sslContextProvider, HostnameVerifier verifier) {
        this.config = config == null ? new ClientConfig(this) : new ClientConfig(this, config);
        this.sslContext = Values.lazy(sslContextProvider != null ? sslContextProvider : this.createSslContextProvider());
        this.hostnameVerifier = verifier;
    }

    private UnsafeValue<SSLContext, IllegalStateException> createSslContextProvider() {
        return new UnsafeValue<SSLContext, IllegalStateException>(){

            public SSLContext get() throws IllegalStateException {
                return SslConfigurator.getDefaultContext();
            }
        };
    }

    public void close() {
        if (this.closedFlag.compareAndSet(false, true)) {
            this.release();
        }
    }

    private void release() {
        LifecycleListener listener;
        while ((listener = this.listeners.pollFirst()) != null) {
            listener.onClose();
        }
    }

    public void addListener(LifecycleListener listener) {
        this.checkNotClosed();
        this.listeners.push(listener);
    }

    public boolean isClosed() {
        return this.closedFlag.get();
    }

    void checkNotClosed() throws IllegalStateException {
        Preconditions.checkState((!this.closedFlag.get() ? 1 : 0) != 0, (Object)LocalizationMessages.CLIENT_INSTANCE_CLOSED());
    }

    public JerseyWebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)LocalizationMessages.CLIENT_URI_TEMPLATE_NULL());
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(URI uri) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uri, (Object)LocalizationMessages.CLIENT_URI_NULL());
        return new JerseyWebTarget(uri, this);
    }

    public JerseyWebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)uriBuilder, (Object)LocalizationMessages.CLIENT_URI_BUILDER_NULL());
        return new JerseyWebTarget(uriBuilder, this);
    }

    public JerseyWebTarget target(Link link) throws NullPointerException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)LocalizationMessages.CLIENT_TARGET_LINK_NULL());
        return new JerseyWebTarget(link, this);
    }

    public JerseyInvocation.Builder invocation(Link link) throws NullPointerException, IllegalArgumentException {
        this.checkNotClosed();
        Preconditions.checkNotNull((Object)link, (Object)LocalizationMessages.CLIENT_INVOCATION_LINK_NULL());
        JerseyWebTarget t = new JerseyWebTarget(link, this);
        String acceptType = link.getType();
        return acceptType != null ? t.request(acceptType) : t.request();
    }

    public JerseyClient register(Class<?> providerClass) {
        this.checkNotClosed();
        this.config.register((Class)providerClass);
        return this;
    }

    public JerseyClient register(Object provider) {
        this.checkNotClosed();
        this.config.register(provider);
        return this;
    }

    public JerseyClient register(Class<?> providerClass, int bindingPriority) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, bindingPriority);
        return this;
    }

    public JerseyClient register(Class<?> providerClass, Class<?> ... contracts) {
        this.checkNotClosed();
        if (contracts != null && contracts.length > 0) {
            this.config.register((Class)providerClass, (Class[])contracts);
        } else {
            LOGGER.log(Level.WARNING, LocalizationMessages.CLIENT_REGISTER_EMPTY_CONTRACT(providerClass));
        }
        return this;
    }

    public JerseyClient register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register((Class)providerClass, (Map)contracts);
        return this;
    }

    public JerseyClient register(Object provider, int bindingPriority) {
        this.checkNotClosed();
        this.config.register(provider, bindingPriority);
        return this;
    }

    public JerseyClient register(Object provider, Class<?> ... contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Class[])contracts);
        return this;
    }

    public JerseyClient register(Object provider, Map<Class<?>, Integer> contracts) {
        this.checkNotClosed();
        this.config.register(provider, (Map)contracts);
        return this;
    }

    public JerseyClient property(String name, Object value) {
        this.checkNotClosed();
        this.config.property(name, value);
        return this;
    }

    public ClientConfig getConfiguration() {
        this.checkNotClosed();
        return this.config.getConfiguration();
    }

    public SSLContext getSslContext() {
        return (SSLContext)this.sslContext.get();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public JerseyClient preInitialize() {
        this.config.preInitialize();
        return this;
    }

    static interface LifecycleListener {
        public void onClose();
    }
}

