/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import jersey.repackaged.com.google.common.base.Function;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientAsyncExecutorLiteral;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientFilteringStages;
import org.glassfish.jersey.client.ClientLifecycleListener;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class ClientRuntime
implements JerseyClient.ShutdownHook {
    private static final Logger LOG = Logger.getLogger(ClientRuntime.class.getName());
    private final Stage<ClientRequest> requestProcessingRoot;
    private final Stage<ClientResponse> responseProcessingRoot;
    private final Connector connector;
    private final ClientConfig config;
    private final RequestScope requestScope;
    private final LazyValue<ExecutorService> asyncRequestExecutor;
    private final Iterable<ClientLifecycleListener> lifecycleListeners;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final InjectionManager injectionManager;

    public ClientRuntime(ClientConfig config, Connector connector, final InjectionManager injectionManager) {
        Stage.Builder requestingChainBuilder = Stages.chain((Function)((Function)injectionManager.createAndInitialize(RequestProcessingInitializationStage.class)));
        ChainableStage<ClientRequest> requestFilteringStage = ClientFilteringStages.createRequestFilteringStage(injectionManager);
        this.requestProcessingRoot = requestFilteringStage != null ? requestingChainBuilder.build(requestFilteringStage) : requestingChainBuilder.build();
        ChainableStage responseFilteringStage = ClientFilteringStages.createResponseFilteringStage(injectionManager);
        this.responseProcessingRoot = responseFilteringStage != null ? responseFilteringStage : Stages.identity();
        this.config = config;
        this.connector = connector;
        this.requestScope = (RequestScope)injectionManager.getInstance(RequestScope.class);
        this.asyncRequestExecutor = Values.lazy((Value)new Value<ExecutorService>(){

            public ExecutorService get() {
                return (ExecutorService)injectionManager.getInstance(ExecutorService.class, new Annotation[]{ClientAsyncExecutorLiteral.INSTANCE});
            }
        });
        this.injectionManager = injectionManager;
        this.lifecycleListeners = Providers.getAllProviders((InjectionManager)injectionManager, ClientLifecycleListener.class);
        for (ClientLifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.onInit();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_INIT(listener.getClass().getName()), t);
            }
        }
    }

    public void submit(final ClientRequest request, final ResponseCallback callback) {
        this.submit((ExecutorService)this.asyncRequestExecutor.get(), new Runnable(){

            @Override
            public void run() {
                try {
                    ClientRequest processedRequest;
                    try {
                        processedRequest = (ClientRequest)((Object)Stages.process((Object)((Object)request), (Stage)ClientRuntime.this.requestProcessingRoot));
                        processedRequest = ClientRuntime.this.addUserAgent(processedRequest, ClientRuntime.this.connector.getName());
                    }
                    catch (AbortException aborted) {
                        ClientRuntime.this.processResponse(aborted.getAbortResponse(), callback);
                        return;
                    }
                    AsyncConnectorCallback connectorCallback = new AsyncConnectorCallback(){

                        @Override
                        public void response(final ClientResponse response) {
                            ClientRuntime.this.requestScope.runInScope(new Runnable(){

                                @Override
                                public void run() {
                                    ClientRuntime.this.processResponse(response, callback);
                                }
                            });
                        }

                        @Override
                        public void failure(final Throwable failure) {
                            ClientRuntime.this.requestScope.runInScope(new Runnable(){

                                @Override
                                public void run() {
                                    ClientRuntime.this.processFailure(failure, callback);
                                }
                            });
                        }
                    };
                    ClientRuntime.this.connector.apply(processedRequest, connectorCallback);
                }
                catch (Throwable throwable) {
                    ClientRuntime.this.processFailure(throwable, callback);
                }
            }
        });
    }

    private void processResponse(ClientResponse response, ResponseCallback callback) {
        ClientResponse processedResponse;
        try {
            processedResponse = (ClientResponse)((Object)Stages.process((Object)((Object)response), this.responseProcessingRoot));
        }
        catch (Throwable throwable) {
            this.processFailure(throwable, callback);
            return;
        }
        callback.completed(processedResponse, this.requestScope);
    }

    private void processFailure(Throwable failure, ResponseCallback callback) {
        callback.failed(failure instanceof ProcessingException ? (ProcessingException)failure : new ProcessingException(failure));
    }

    private Future<?> submit(ExecutorService executor, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                ClientRuntime.this.requestScope.runInScope(task);
            }
        });
    }

    private ClientRequest addUserAgent(ClientRequest clientRequest, String connectorName) {
        MultivaluedMap headers = clientRequest.getHeaders();
        if (headers.containsKey((Object)"User-Agent")) {
            if (clientRequest.getHeaderString("User-Agent") == null) {
                headers.remove((Object)"User-Agent");
            }
        } else if (!clientRequest.ignoreUserAgent()) {
            if (connectorName != null && !connectorName.isEmpty()) {
                headers.put((Object)"User-Agent", Arrays.asList(String.format("Jersey/%s (%s)", Version.getVersion(), connectorName)));
            } else {
                headers.put((Object)"User-Agent", Arrays.asList(String.format("Jersey/%s", Version.getVersion())));
            }
        }
        return clientRequest;
    }

    public ClientResponse invoke(ClientRequest request) {
        try {
            ClientResponse response;
            try {
                response = this.connector.apply(this.addUserAgent((ClientRequest)((Object)Stages.process((Object)((Object)request), this.requestProcessingRoot)), this.connector.getName()));
            }
            catch (AbortException aborted) {
                response = aborted.getAbortResponse();
            }
            return (ClientResponse)((Object)Stages.process((Object)((Object)response), this.responseProcessingRoot));
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Throwable t) {
            throw new ProcessingException(t.getMessage(), t);
        }
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (ClientLifecycleListener listener : this.lifecycleListeners) {
                    try {
                        listener.onClose();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_CLOSE(listener.getClass().getName()), t);
                    }
                }
            }
            finally {
                try {
                    this.connector.close();
                }
                finally {
                    this.injectionManager.shutdown();
                }
            }
        }
    }

    public void preInitialize() {
        this.injectionManager.getInstance(MessageBodyWorkers.class);
    }

    public Connector getConnector() {
        return this.connector;
    }

    InjectionManager getInjectionManager() {
        return this.injectionManager;
    }
}

