
package org.glassfish.jersey.client.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.client.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCLIENT_TARGET_LINK_NULL() {
        return messageFactory.getMessage("client.target.link.null");
    }

    /**
     * Link to the newly created target must not be null.
     * 
     */
    public static String CLIENT_TARGET_LINK_NULL() {
        return localizer.localize(localizableCLIENT_TARGET_LINK_NULL());
    }

    public static Localizable localizableCLIENT_URI_NULL() {
        return messageFactory.getMessage("client.uri.null");
    }

    /**
     * URI of the newly created target must not be null.
     * 
     */
    public static String CLIENT_URI_NULL() {
        return localizer.localize(localizableCLIENT_URI_NULL());
    }

    public static Localizable localizableCLIENT_URI_TEMPLATE_NULL() {
        return messageFactory.getMessage("client.uri.template.null");
    }

    /**
     * URI template of the newly created target must not be null.
     * 
     */
    public static String CLIENT_URI_TEMPLATE_NULL() {
        return localizer.localize(localizableCLIENT_URI_TEMPLATE_NULL());
    }

    public static Localizable localizableNULL_SSL_CONTEXT() {
        return messageFactory.getMessage("null.ssl.context");
    }

    /**
     * Custom client SSL context, if set, must not be null.
     * 
     */
    public static String NULL_SSL_CONTEXT() {
        return localizer.localize(localizableNULL_SSL_CONTEXT());
    }

    public static Localizable localizableCLIENT_INVOCATION_LINK_NULL() {
        return messageFactory.getMessage("client.invocation.link.null");
    }

    /**
     * Link of the newly created invocation must not be null.
     * 
     */
    public static String CLIENT_INVOCATION_LINK_NULL() {
        return localizer.localize(localizableCLIENT_INVOCATION_LINK_NULL());
    }

    public static Localizable localizableUNEXPECTED_ERROR_RESPONSE_PROCESSING() {
        return messageFactory.getMessage("unexpected.error.response.processing");
    }

    /**
     * Unexpected error during response processing.
     * 
     */
    public static String UNEXPECTED_ERROR_RESPONSE_PROCESSING() {
        return localizer.localize(localizableUNEXPECTED_ERROR_RESPONSE_PROCESSING());
    }

    public static Localizable localizableCLIENT_INSTANCE_CLOSED() {
        return messageFactory.getMessage("client.instance.closed");
    }

    /**
     * Client instance has been closed.
     * 
     */
    public static String CLIENT_INSTANCE_CLOSED() {
        return localizer.localize(localizableCLIENT_INSTANCE_CLOSED());
    }

    public static Localizable localizableHTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY() {
        return messageFactory.getMessage("httpurlconnection.replaces.get.with.entity");
    }

    /**
     * Detected non-empty entity on a HTTP GET request. The underlying HTTP transport connector may decide to change the request method to POST.
     * 
     */
    public static String HTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY() {
        return localizer.localize(localizableHTTPURLCONNECTION_REPLACES_GET_WITH_ENTITY());
    }

    public static Localizable localizableERROR_HTTP_METHOD_ENTITY_NULL(Object arg0) {
        return messageFactory.getMessage("error.http.method.entity.null", arg0);
    }

    /**
     * Entity must not be null for http method {0}.
     * 
     */
    public static String ERROR_HTTP_METHOD_ENTITY_NULL(Object arg0) {
        return localizer.localize(localizableERROR_HTTP_METHOD_ENTITY_NULL(arg0));
    }

    public static Localizable localizableCLIENT_URI_BUILDER_NULL() {
        return messageFactory.getMessage("client.uri.builder.null");
    }

    /**
     * URI builder of the newly created target must not be null.
     * 
     */
    public static String CLIENT_URI_BUILDER_NULL() {
        return localizer.localize(localizableCLIENT_URI_BUILDER_NULL());
    }

    public static Localizable localizableCHUNKED_INPUT_CLOSED() {
        return messageFactory.getMessage("chunked.input.closed");
    }

    /**
     * Chunked input has been closed already.
     * 
     */
    public static String CHUNKED_INPUT_CLOSED() {
        return localizer.localize(localizableCHUNKED_INPUT_CLOSED());
    }

    public static Localizable localizableNULL_TRUSTSTORE() {
        return messageFactory.getMessage("null.truststore");
    }

    /**
     * Custom trust store, if set, must not be null.
     * 
     */
    public static String NULL_TRUSTSTORE() {
        return localizer.localize(localizableNULL_TRUSTSTORE());
    }

    public static Localizable localizableREQUEST_ENTITY_WRITER_NULL() {
        return messageFactory.getMessage("request.entity.writer.null");
    }

    /**
     * The entity of the client request is null.
     * 
     */
    public static String REQUEST_ENTITY_WRITER_NULL() {
        return localizer.localize(localizableREQUEST_ENTITY_WRITER_NULL());
    }

    public static Localizable localizableERROR_CLOSING_OUTPUT_STREAM() {
        return messageFactory.getMessage("error.closing.output.stream");
    }

    /**
     * Error when closing the output stream.
     * 
     */
    public static String ERROR_CLOSING_OUTPUT_STREAM() {
        return localizer.localize(localizableERROR_CLOSING_OUTPUT_STREAM());
    }

    public static Localizable localizableCHUNKED_INPUT_STREAM_CLOSING_ERROR() {
        return messageFactory.getMessage("chunked.input.stream.closing.error");
    }

    /**
     * Error closing chunked input's underlying response input stream.
     * 
     */
    public static String CHUNKED_INPUT_STREAM_CLOSING_ERROR() {
        return localizer.localize(localizableCHUNKED_INPUT_STREAM_CLOSING_ERROR());
    }

    public static Localizable localizableCHUNKED_INPUT_MEDIA_TYPE_NULL() {
        return messageFactory.getMessage("chunked.input.media.type.null");
    }

    /**
     * Specified chunk media type must not be null.
     * 
     */
    public static String CHUNKED_INPUT_MEDIA_TYPE_NULL() {
        return localizer.localize(localizableCHUNKED_INPUT_MEDIA_TYPE_NULL());
    }

    public static Localizable localizableERROR_HTTP_METHOD_ENTITY_NOT_NULL(Object arg0) {
        return messageFactory.getMessage("error.http.method.entity.not.null", arg0);
    }

    /**
     * Entity must be null for http method {0}.
     * 
     */
    public static String ERROR_HTTP_METHOD_ENTITY_NOT_NULL(Object arg0) {
        return localizer.localize(localizableERROR_HTTP_METHOD_ENTITY_NOT_NULL(arg0));
    }

    public static Localizable localizableNULL_KEYSTORE() {
        return messageFactory.getMessage("null.keystore");
    }

    /**
     * Custom key store, if set, must not be null.
     * 
     */
    public static String NULL_KEYSTORE() {
        return localizer.localize(localizableNULL_KEYSTORE());
    }

    public static Localizable localizableUSE_ENCODING_IGNORED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("use.encoding.ignored", arg0, arg1, arg2);
    }

    /**
     * Value {1} of {0} client property will be ignored as it is not a valid supported encoding. Valid supported encodings are: {2}
     * 
     */
    public static String USE_ENCODING_IGNORED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableUSE_ENCODING_IGNORED(arg0, arg1, arg2));
    }

    public static Localizable localizableERROR_COMMITTING_OUTPUT_STREAM() {
        return messageFactory.getMessage("error.committing.output.stream");
    }

    /**
     * Error while committing the request output stream.
     * 
     */
    public static String ERROR_COMMITTING_OUTPUT_STREAM() {
        return localizer.localize(localizableERROR_COMMITTING_OUTPUT_STREAM());
    }

    public static Localizable localizableREQUEST_ENTITY_ALREADY_WRITTEN() {
        return messageFactory.getMessage("request.entity.already.written");
    }

    /**
     * The entity was already written in this request. The entity can be written (serialized into the output stream) only once per a request.
     * 
     */
    public static String REQUEST_ENTITY_ALREADY_WRITTEN() {
        return localizer.localize(localizableREQUEST_ENTITY_ALREADY_WRITTEN());
    }

    public static Localizable localizableRESPONSE_TO_EXCEPTION_CONVERSION_FAILED() {
        return messageFactory.getMessage("response.to.exception.conversion.failed");
    }

    /**
     * Failed to convert a response into an exception.
     * 
     */
    public static String RESPONSE_TO_EXCEPTION_CONVERSION_FAILED() {
        return localizer.localize(localizableRESPONSE_TO_EXCEPTION_CONVERSION_FAILED());
    }

    public static Localizable localizableERROR_DIGEST_FILTER_GENERATOR() {
        return messageFactory.getMessage("error.digest.filter.generator");
    }

    /**
     * Error during initialization of random generator of HttpDigestAuthFilter.
     * 
     */
    public static String ERROR_DIGEST_FILTER_GENERATOR() {
        return localizer.localize(localizableERROR_DIGEST_FILTER_GENERATOR());
    }

    public static Localizable localizableNULL_KEYSTORE_PASWORD() {
        return messageFactory.getMessage("null.keystore.pasword");
    }

    /**
     * Custom key store password must not be null.
     * 
     */
    public static String NULL_KEYSTORE_PASWORD() {
        return localizer.localize(localizableNULL_KEYSTORE_PASWORD());
    }

    public static Localizable localizableRESPONSE_TYPE_IS_NULL() {
        return messageFactory.getMessage("response.type.is.null");
    }

    /**
     * Requested response type is null.
     * 
     */
    public static String RESPONSE_TYPE_IS_NULL() {
        return localizer.localize(localizableRESPONSE_TYPE_IS_NULL());
    }

}
