/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.base.Preconditions;
import org.glassfish.hk2.Binder;
import org.glassfish.hk2.BinderFactory;
import org.glassfish.hk2.Module;
import org.glassfish.hk2.NamedBinder;
import org.glassfish.hk2.TypeLiteral;

public abstract class AbstractModule
implements Module,
BinderFactory {
    private transient BinderFactory binderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(BinderFactory binderFactory) {
        Preconditions.checkState((this.binderFactory == null ? 1 : 0) != 0, (Object)"Recursive configuration call detected.");
        this.binderFactory = (BinderFactory)Preconditions.checkNotNull((Object)binderFactory, (Object)"binderFactory");
        try {
            this.configure();
        }
        finally {
            this.binderFactory = null;
        }
    }

    protected abstract void configure();

    private BinderFactory binderFactory() {
        Preconditions.checkState((this.binderFactory != null ? 1 : 0) != 0, (Object)"Binder factory accessed from outside of an active module configuration scope.");
        return this.binderFactory;
    }

    public final BinderFactory inParent() {
        return this.binderFactory().inParent();
    }

    public final Binder<Object> bind(String contractName) {
        return this.binderFactory().bind(contractName);
    }

    public final Binder<Object> bind(String ... contractNames) {
        return this.binderFactory().bind(contractNames);
    }

    public final <T> Binder<T> bind(Class<T> contract, Class<?> ... contracts) {
        return this.binderFactory().bind(contract, (Class[])contracts);
    }

    public final <T> Binder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binderFactory().bind(typeLiteral);
    }

    public final NamedBinder<Object> bind() {
        return this.binderFactory().bind();
    }

    public final void install(Module ... modules) {
        for (Module module : modules) {
            module.configure((BinderFactory)this);
        }
    }
}

