/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.sun.hk2.component.InjectionResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.ws.rs.core.Context;
import org.glassfish.hk2.ContractLocator;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.Providers;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.tiger_types.Types;

public class ContextInjectionResolver
extends InjectionResolver<Context> {
    @Inject
    Services services;

    public ContextInjectionResolver() {
        super(Context.class);
    }

    public boolean isOptional(AnnotatedElement annotated, Context annotation) {
        return true;
    }

    public <V> V getValue(Object component, Inhabitant<?> onBehalfOf, AnnotatedElement annotated, Type genericType, Class<V> type) throws ComponentException {
        boolean isHk2Factory = Types.isSubClassOf(type, Factory.class);
        String targetTypeName = isHk2Factory ? ContextInjectionResolver.exploreType(Types.getTypeArgument((Type)genericType, (int)0)) : ContextInjectionResolver.exploreType(genericType);
        ContractLocator locator = this.services.forContract(targetTypeName);
        for (Annotation a : annotated.getAnnotations()) {
            Class<? extends Annotation> ac = a.annotationType();
            if (Named.class.isAssignableFrom(ac)) {
                locator = locator.named(((Named)Named.class.cast(a)).value());
                continue;
            }
            if (!ac.isAnnotationPresent(Qualifier.class)) continue;
            locator = locator.annotatedWith(ac);
        }
        Provider provider = locator.getProvider();
        if (isHk2Factory) {
            return (V)(provider == null ? Providers.asFactory(this.services.byType(targetTypeName).getProvider()) : Providers.asFactory(provider));
        }
        return (V)(provider == null ? this.services.byType(targetTypeName).get() : provider.get());
    }

    private static void exploreType(Type type, StringBuilder builder) {
        if (type instanceof ParameterizedType) {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
            List<Type> types = Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
            Iterator typesEnum = types.iterator();
            ArrayList<Type> nonWildcards = new ArrayList<Type>();
            while (typesEnum.hasNext()) {
                Type genericType = (Type)typesEnum.next();
                if (genericType instanceof WildcardType) continue;
                nonWildcards.add(genericType);
            }
            if (!nonWildcards.isEmpty()) {
                builder.append("<");
                Iterator typesItr = nonWildcards.iterator();
                while (typesItr.hasNext()) {
                    ContextInjectionResolver.exploreType((Type)typesItr.next(), builder);
                    if (!typesItr.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(">");
            }
        } else {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
        }
    }

    private static String exploreType(Type type) {
        StringBuilder builder = new StringBuilder();
        ContextInjectionResolver.exploreType(type, builder);
        return builder.toString();
    }

    public static final class Module
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind(InjectionResolver.class, new Class[0]).to(ContextInjectionResolver.class).in(Singleton.class);
        }
    }
}

