/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Provider;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.jersey.internal.inject.ProviderToService;

public class Providers {
    private Providers() {
    }

    public static <T> Factory<T> asFactory(final Provider<T> provider) {
        return new Factory<T>(){

            public T get() {
                return provider.get();
            }
        };
    }

    public static <T> Factory<T> factoryOf(final T instance) {
        return new Factory<T>(){

            public T get() {
                return instance;
            }
        };
    }

    private static void exploreType(Type type, StringBuilder builder) {
        if (type instanceof ParameterizedType) {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
            List<Type> types = Arrays.asList(((ParameterizedType)type).getActualTypeArguments());
            Iterator typesEnum = types.iterator();
            ArrayList<Type> nonWildcards = new ArrayList<Type>();
            while (typesEnum.hasNext()) {
                Type genericType = (Type)typesEnum.next();
                if (genericType instanceof WildcardType) continue;
                nonWildcards.add(genericType);
            }
            if (!nonWildcards.isEmpty()) {
                builder.append("<");
                Iterator typesItr = nonWildcards.iterator();
                while (typesItr.hasNext()) {
                    Providers.exploreType((Type)typesItr.next(), builder);
                    if (!typesItr.hasNext()) continue;
                    builder.append(",");
                }
                builder.append(">");
            }
        } else {
            builder.append(TypeLiteral.getRawType((Type)type).getName());
        }
    }

    private static String exploreType(Type type) {
        StringBuilder builder = new StringBuilder();
        Providers.exploreType(type, builder);
        return builder.toString();
    }

    private static String exploreType(TypeLiteral<?> typeLiteral) {
        StringBuilder builder = new StringBuilder();
        Providers.exploreType(typeLiteral.getType(), builder);
        return builder.toString();
    }

    public static String contractStringFor(Class<?> rawType, Type ... types) {
        StringBuilder builder = new StringBuilder(rawType.getName());
        if (types != null && types.length > 0) {
            builder.append('<').append(Providers.exploreType(types[0]));
            for (int i = 1; i < types.length; ++i) {
                builder.append(',').append(Providers.exploreType(types[i]));
            }
            builder.append('>');
        }
        return builder.toString();
    }

    public static <T> T getContract(Services services, String contract) {
        return (T)services.forContract(contract).all();
    }

    public static <T> Provider<T> getProvider(Services services, String contract) {
        return services.forContract(contract).getProvider();
    }

    public static <T> Factory<T> getFactory(Services services, String contract) {
        return Providers.asFactory(services.forContract(contract).getProvider());
    }

    public static <T> Set<T> getProviders(Services services, Class<T> contract) {
        Collection hk2Providers = services.forContract(contract).all();
        if (hk2Providers.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        return Sets.newLinkedHashSet((Iterable)Collections2.transform((Collection)hk2Providers, new ProviderToService()));
    }

    public static <T> SortedSet<T> getProviders(Services services, Class<T> contract, Comparator<T> comparator) {
        Collection hk2Providers = services.forContract(contract).all();
        if (hk2Providers.isEmpty()) {
            return Sets.newTreeSet(comparator);
        }
        TreeSet set = Sets.newTreeSet(comparator);
        set.addAll(Collections2.transform((Collection)hk2Providers, new ProviderToService()));
        return set;
    }

    public static <T> Set<T> getProviderFactories(Services services, Class<T> contract) {
        Collection hk2Providers = services.forContract(contract).all();
        if (hk2Providers.isEmpty()) {
            return Sets.newLinkedHashSet();
        }
        return Sets.newLinkedHashSet((Iterable)Collections2.transform((Collection)hk2Providers, new ProviderToService()));
    }
}

