/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.internal.util.collection.LinkedListSupplier;

final class HeadersFactory {
    private static Supplier<? extends List<String>> LINKED_STRING_LIST_SUPPLIER = new LinkedListSupplier<String>();
    private static Supplier<? extends List<Object>> LINKED_OBJECT_LIST_SUPPLIER = new LinkedListSupplier<Object>();

    public static ListMultimap<String, String> createInbound() {
        return Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_STRING_LIST_SUPPLIER);
    }

    public static ListMultimap<String, String> createInbound(ListMultimap<String, String> initial) {
        ListMultimap headers = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_STRING_LIST_SUPPLIER);
        headers.putAll(initial);
        return headers;
    }

    public static ListMultimap<String, String> createInbound(Map<String, List<String>> initial) {
        ListMultimap headers = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_STRING_LIST_SUPPLIER);
        for (Map.Entry<String, List<String>> e : initial.entrySet()) {
            headers.putAll((Object)e.getKey(), (Iterable)e.getValue());
        }
        return headers;
    }

    public static <V> ListMultimap<String, V> empty() {
        return ImmutableListMultimap.of();
    }

    public static ListMultimap<String, Object> createOutbound() {
        return Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_OBJECT_LIST_SUPPLIER);
    }

    public static ListMultimap<String, Object> createOutbound(ListMultimap<String, Object> initial) {
        ListMultimap headers = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_OBJECT_LIST_SUPPLIER);
        headers.putAll(initial);
        return headers;
    }

    public static ListMultimap<String, Object> createOutbound(Map<String, List<Object>> initial) {
        ListMultimap headers = Multimaps.newListMultimap(new TreeMap(String.CASE_INSENSITIVE_ORDER), LINKED_OBJECT_LIST_SUPPLIER);
        for (Map.Entry<String, List<Object>> e : initial.entrySet()) {
            headers.putAll((Object)e.getKey(), (Iterable)e.getValue());
        }
        return headers;
    }

    public static String toString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate hp;
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> toString(List<Object> headerValues, final RuntimeDelegate rd) {
        return Lists.transform(headerValues, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return HeadersFactory.toString(input, rd);
            }
        });
    }

    public static ListMultimap<String, String> toString(ListMultimap<String, Object> headers, final RuntimeDelegate rd) {
        return Multimaps.transformValues(headers, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return HeadersFactory.toString(input, rd);
            }
        });
    }

    private HeadersFactory() {
    }
}

