/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.RequestHeaders;
import org.glassfish.jersey.internal.util.collection.ListMultimapAdapter;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.Headers;
import org.glassfish.jersey.message.internal.HttpHelper;

class JaxrsRequestHeadersView
implements RequestHeaders,
HttpHeaders {
    private Headers wrapped;

    public JaxrsRequestHeadersView(Headers wrapped) {
        this.wrapped = wrapped;
    }

    static JaxrsRequestHeadersView unwrap(RequestHeaders headers) {
        if (headers instanceof JaxrsRequestHeadersView) {
            return (JaxrsRequestHeadersView)headers;
        }
        throw new IllegalArgumentException(String.format("Request headers class type '%s' not supported.", headers.getClass().getName()));
    }

    public List<MediaType> getAcceptableMediaTypes() {
        return new ArrayList<MediaType>(HttpHelper.getAccept(this.wrapped));
    }

    public List<Locale> getAcceptableLanguages() {
        List<AcceptableLanguageTag> alts = HttpHelper.getAcceptLanguage(this.wrapped);
        ArrayList<Locale> acceptLanguages = new ArrayList<Locale>(alts.size());
        for (AcceptableLanguageTag alt : alts) {
            acceptLanguages.add(alt.getAsLocale());
        }
        return acceptLanguages;
    }

    public Map<String, Cookie> getCookies() {
        return HttpHelper.getCookies(this.wrapped);
    }

    public Date getDate() {
        return HttpHelper.getDate(this.wrapped);
    }

    public String getHeader(String name) {
        return this.wrapped.header(name);
    }

    public MultivaluedMap<String, String> asMap() {
        return new ListMultimapAdapter<String, String>(this.wrapped.headers());
    }

    public List<String> getHeaderValues(String name) {
        return this.wrapped.headerValues(name);
    }

    public Locale getLanguage() {
        return HttpHelper.getContentLanguageAsLocale(this.wrapped);
    }

    public int getLength() {
        return HttpHelper.getContentLength(this.wrapped);
    }

    public MediaType getMediaType() {
        return HttpHelper.getContentType(this.wrapped);
    }

    public List<String> getRequestHeader(String name) {
        return this.wrapped.headerValues(name);
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.asMap();
    }

    public Set<Link> getLinks() {
        return HttpHelper.getLinks(this.wrapped);
    }

    public Link getLink(String relation) {
        for (Link l : HttpHelper.getLinks(this.wrapped)) {
            List rels = l.getRel();
            if (rels == null || !rels.contains(relation)) continue;
            return l;
        }
        return null;
    }

    public boolean hasLink(String relation) {
        for (Link l : HttpHelper.getLinks(this.wrapped)) {
            List rels = l.getRel();
            if (rels == null || !rels.contains(relation)) continue;
            return true;
        }
        return false;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }
}

