/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.RequestHeaders;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMutableMessage;
import org.glassfish.jersey.message.internal.JaxrsRequestBuilderView;
import org.glassfish.jersey.message.internal.JaxrsRequestHeadersView;
import org.glassfish.jersey.message.internal.JaxrsRequestView;
import org.glassfish.jersey.message.internal.Request;
import org.glassfish.jersey.uri.UriComponent;

class MutableRequest
extends AbstractMutableMessage<MutableRequest>
implements Request,
Request.Builder {
    private transient javax.ws.rs.core.Request jaxrsView;
    private transient Request.RequestBuilder jaxrsBuilderView;
    private transient RequestHeaders jaxrsHeadersView;
    private URI applicationRootUri;
    private URI requestUri;
    private String encodedRelativePath = null;
    private String decodedRelativePath = null;
    private String method;

    MutableRequest(MutableRequest that) {
        super(that);
        this.applicationRootUri = that.applicationRootUri;
        this.requestUri = that.requestUri;
        this.method = that.method;
    }

    MutableRequest(URI applicationRootUri, URI requestUri, String method) {
        this.applicationRootUri = applicationRootUri;
        this.requestUri = requestUri;
        this.method = method;
    }

    MutableRequest(String applicationRootUri, String requestUri, String method) {
        this.applicationRootUri = URI.create(applicationRootUri != null ? applicationRootUri : "/");
        this.requestUri = URI.create(requestUri);
        this.method = method;
    }

    MutableRequest(Request request) {
        super(request.headers(), request.content(InputStream.class), request.properties());
        this.applicationRootUri = request.baseUri();
        this.requestUri = request.uri();
        this.method = request.method();
    }

    @Override
    public URI baseUri() {
        return this.applicationRootUri;
    }

    @Override
    public String relativePath(boolean decode) {
        if (decode) {
            if (this.decodedRelativePath != null) {
                return this.decodedRelativePath;
            }
            this.decodedRelativePath = UriComponent.decode(this.encodedRelativePath(), UriComponent.Type.PATH);
            return this.decodedRelativePath;
        }
        return this.encodedRelativePath();
    }

    private String encodedRelativePath() {
        String applicationRootUriRawPath;
        if (this.encodedRelativePath != null) {
            return this.encodedRelativePath;
        }
        String requestUriRawPath = this.requestUri.getRawPath();
        String result = this.applicationRootUri == null ? requestUriRawPath : ((applicationRootUriRawPath = this.applicationRootUri.getRawPath()).length() > requestUriRawPath.length() ? "" : requestUriRawPath.substring(applicationRootUriRawPath.length()));
        if (result.equals("")) {
            result = "/";
        }
        this.encodedRelativePath = result.charAt(0) == '/' ? result : '/' + result;
        return this.encodedRelativePath;
    }

    @Override
    public URI uri() {
        return this.requestUri;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public MutableRequest uri(String uri) {
        this.applicationRootUri = this.requestUri = URI.create(uri);
        return this;
    }

    @Override
    public MutableRequest uri(URI uri) {
        this.applicationRootUri = this.requestUri = uri;
        return this;
    }

    @Override
    public Request.Builder uris(String applicationRootUri, String requestUri) {
        this.applicationRootUri = URI.create(applicationRootUri);
        this.requestUri = URI.create(requestUri);
        return this;
    }

    @Override
    public Request.Builder uris(URI applicationRootUri, URI requestUri) {
        this.applicationRootUri = applicationRootUri;
        this.requestUri = requestUri;
        return this;
    }

    @Override
    public MutableRequest method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public MutableRequest clone() {
        return new MutableRequest(this);
    }

    @Override
    public javax.ws.rs.core.Request toJaxrsRequest() {
        if (this.jaxrsView == null) {
            this.jaxrsView = new JaxrsRequestView(this);
        }
        return this.jaxrsView;
    }

    @Override
    public Request.RequestBuilder toJaxrsRequestBuilder() {
        if (this.jaxrsBuilderView == null) {
            this.jaxrsBuilderView = new JaxrsRequestBuilderView(this);
        }
        return this.jaxrsBuilderView;
    }

    @Override
    public RequestHeaders getJaxrsHeaders() {
        if (this.jaxrsHeadersView == null) {
            this.jaxrsHeadersView = new JaxrsRequestHeadersView(this);
        }
        return this.jaxrsHeadersView;
    }

    @Override
    public Request.Builder workers(MessageBodyWorkers workers) {
        this.entityWorkers(workers);
        return this;
    }

    @Override
    public MessageBodyWorkers workers() {
        return this.entityWorkers();
    }
}

