/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.FilterContext;
import javax.ws.rs.ext.PreMatchRequestFilter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.RequestFilter;
import javax.ws.rs.ext.ResponseFilter;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;

@Provider
@BindingPriority(value=-2147483648)
public class LoggingFilter
implements PreMatchRequestFilter,
RequestFilter,
ResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(LoggingFilter.class.getName());
    private static final String NOTIFICATION_PREFIX = "* ";
    private static final String REQUEST_PREFIX = "> ";
    private static final String RESPONSE_PREFIX = "< ";
    private final Logger logger;
    private final AtomicLong _id = new AtomicLong(0L);
    private boolean printEntity = true;

    public LoggingFilter() {
        this(LOGGER, false);
    }

    public LoggingFilter(Logger logger, boolean printEntity) {
        this.logger = logger;
        this.printEntity = printEntity;
    }

    public void preMatchFilter(FilterContext context) throws IOException {
        long id = this._id.incrementAndGet();
        context.setRequest(this.logRequest(id, context.getRequest()));
    }

    public void postFilter(FilterContext context) throws IOException {
        long id = this._id.incrementAndGet();
        context.setResponse(this.logResponse(id, context.getResponse()));
    }

    public void preFilter(FilterContext context) throws IOException {
        long id = this._id.incrementAndGet();
        context.setRequest(this.logRequest(id, context.getRequest()));
    }

    private void log(StringBuilder b) {
        if (this.logger != null) {
            this.logger.info(b.toString());
        }
    }

    private Request logRequest(long id, Request request) throws IOException {
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, id, request);
        this.printPrefixedHeaders(b, id, REQUEST_PREFIX, (Map<String, List<String>>)request.getHeaders().asMap());
        if (this.printEntity && request.hasEntity()) {
            Object entity = request.getEntity();
            if (entity != null && entity.getClass().isAssignableFrom(InputStream.class)) {
                InputStream in = (InputStream)entity;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (in.available() > 0) {
                    ReaderWriter.writeTo(in, out);
                    byte[] requestEntity = out.toByteArray();
                    b.append(new String(requestEntity, Charset.defaultCharset())).append("\n");
                    request = Requests.from(request).entity((Object)new ByteArrayInputStream(requestEntity)).build();
                }
            } else {
                b.append((String)request.readEntity(String.class)).append("\n");
            }
        }
        this.log(b);
        return request;
    }

    private Response logResponse(long id, Response response) throws IOException {
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, id, response);
        this.printPrefixedHeaders(b, id, RESPONSE_PREFIX, (Map<String, List<String>>)response.getHeaders().asMap());
        if (this.printEntity && response.hasEntity()) {
            Object entity = response.getEntity();
            if (entity != null && entity.getClass().isAssignableFrom(InputStream.class)) {
                InputStream in = (InputStream)entity;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (in.available() > 0) {
                    ReaderWriter.writeTo(in, out);
                    byte[] requestEntity = out.toByteArray();
                    b.append(new String(requestEntity, Charset.defaultCharset())).append("\n");
                    response = Responses.toBuilder(response).entity((Object)new ByteArrayInputStream(requestEntity)).build();
                }
            } else {
                b.append((String)response.readEntity(String.class)).append("\n");
            }
        }
        this.log(b);
        return response;
    }

    private StringBuilder prefixId(StringBuilder b, long id) {
        b.append(Long.toString(id)).append(" ");
        return b;
    }

    private void printRequestLine(StringBuilder b, long id, Request request) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append("LoggingFilter - Request received on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(REQUEST_PREFIX).append(request.getMethod()).append(" ").append(request.getUri().toASCIIString()).append("\n");
    }

    private void printResponseLine(StringBuilder b, long id, Response response) {
        this.prefixId(b, id).append(NOTIFICATION_PREFIX).append("LoggingFilter - Response received on thread ").append(Thread.currentThread().getName()).append("\n");
        this.prefixId(b, id).append(RESPONSE_PREFIX).append(Integer.toString(response.getStatus())).append("\n");
    }

    private void printPrefixedHeaders(StringBuilder b, long id, String prefix, Map<String, List<String>> headers) {
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            List<String> val = e.getValue();
            String header = e.getKey();
            if (val.size() == 1) {
                this.prefixId(b, id).append(prefix).append(header).append(": ").append(val.get(0)).append("\n");
                continue;
            }
            StringBuilder sb = new StringBuilder();
            boolean add = false;
            for (String s : val) {
                if (add) {
                    sb.append(',');
                }
                add = true;
                sb.append(s);
            }
            this.prefixId(b, id).append(prefix).append(header).append(": ").append(sb.toString()).append("\n");
        }
    }
}

