/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import java.util.Deque;
import java.util.LinkedList;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.process.internal.Responder;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stages;

public class DefaultRespondingContext
implements ResponseProcessor.RespondingContext {
    Deque<Function<Response, Response>> transformationStack = new LinkedList<Function<Response, Response>>();

    @Override
    public void push(Function<Response, Response> responseTransformation) {
        this.transformationStack.push(responseTransformation);
    }

    @Override
    public Optional<Responder> createStageChain() {
        if (this.transformationStack.isEmpty()) {
            return Optional.absent();
        }
        Responder.Builder chainBuilder = Stages.respondingChain(this.transformationStack.pop());
        while (!this.transformationStack.isEmpty()) {
            chainBuilder.to(this.transformationStack.pop());
        }
        return Optional.of((Object)chainBuilder.build());
    }
}

