/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import java.util.Iterator;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.Inflecting;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.StagingContext;
import org.glassfish.jersey.process.internal.TreeAcceptor;
import org.jvnet.hk2.annotations.Inject;

public class HierarchicalRequestProcessor
implements RequestProcessor {
    private final TreeAcceptor rootStage;
    private final Factory<StagingContext<Request>> contextProvider;

    public HierarchicalRequestProcessor(@Inject @Stage.Root TreeAcceptor rootStage, @Inject Factory<StagingContext<Request>> contextProvider) {
        this.rootStage = rootStage;
        this.contextProvider = contextProvider;
    }

    @Override
    public Pair<Request, Optional<Inflector<Request, Response>>> apply(Request request) {
        return this._apply(request, this.rootStage, (StagingContext)this.contextProvider.get());
    }

    private Pair<Request, Optional<Inflector<Request, Response>>> _apply(Request request, TreeAcceptor acceptor, StagingContext<Request> context) {
        context.beforeStage(acceptor, request);
        Pair<Request, Iterator<TreeAcceptor>> continuation = acceptor.apply(request);
        context.afterStage(acceptor, continuation.left());
        Iterator<TreeAcceptor> children = continuation.right();
        while (children.hasNext()) {
            TreeAcceptor child = children.next();
            Pair<Request, Optional<Inflector<Request, Response>>> result = this._apply(continuation.left(), child, context);
            if (!result.right().isPresent()) continue;
            return result;
        }
        if (acceptor instanceof Inflecting) {
            return Tuples.of(continuation.left(), Optional.of(((Inflecting)((Object)acceptor)).inflector()));
        }
        return Tuples.of(continuation.left(), Optional.absent());
    }
}

