/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.io.IOException;
import java.io.OutputStream;

public abstract class CommittingOutputStream
extends OutputStream {
    private OutputStream adaptedOutput;
    private boolean isCommitted = false;

    public CommittingOutputStream() {
    }

    public CommittingOutputStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException();
        }
        this.adaptedOutput = out;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b.length > 0) {
            this.commitWrite();
            this.adaptedOutput.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            this.commitWrite();
            this.adaptedOutput.write(b, off, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.commitWrite();
        this.adaptedOutput.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.commitWrite();
        this.adaptedOutput.flush();
    }

    @Override
    public void close() throws IOException {
        this.commitWrite();
        this.adaptedOutput.close();
    }

    private void commitWrite() throws IOException {
        if (!this.isCommitted) {
            this.isCommitted = true;
            this.commit();
            if (this.adaptedOutput == null) {
                this.adaptedOutput = this.getOutputStream();
            }
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        throw new IllegalStateException();
    }

    protected abstract void commit() throws IOException;
}

