/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.jvnet.tiger_types.Types;

public final class InstanceTypePair<T>
implements Pair<T, Type> {
    private final T t;
    private final Type type;

    private InstanceTypePair(T t) {
        this.t = t;
        this.type = t.getClass();
    }

    private InstanceTypePair(T t, TypeLiteral<T> type) {
        this.t = t;
        this.type = type.getType();
    }

    private InstanceTypePair(T t, Type type) {
        Preconditions.checkArgument((boolean)Types.isSubClassOf(t.getClass(), (Type)type), (Object)"Supplied type not compatible with instance.");
        this.t = t;
        this.type = type;
    }

    @Override
    public T left() {
        return this.t;
    }

    @Override
    public Type right() {
        return this.type;
    }

    public T instance() {
        return this.left();
    }

    public Type type() {
        return this.right();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("instance", this.t).add("type", (Object)this.type).toString();
    }

    public static <T> InstanceTypePair<T> of(T instance) {
        return new InstanceTypePair<T>(instance);
    }

    public static <T> InstanceTypePair<T> of(T instance, TypeLiteral<T> type) {
        return new InstanceTypePair<T>(instance, type);
    }

    public static <T> InstanceTypePair<T> of(T instance, Type type) {
        return new InstanceTypePair<T>(instance, type);
    }
}

