/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import javax.ws.rs.core.Response;
import javax.ws.rs.core.ResponseHeaders;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMutableMessage;
import org.glassfish.jersey.message.internal.JaxrsResponseBuilderView;
import org.glassfish.jersey.message.internal.JaxrsResponseHeadersView;
import org.glassfish.jersey.message.internal.JaxrsResponseView;
import org.glassfish.jersey.message.internal.Response;
import org.glassfish.jersey.message.internal.Statuses;

class MutableResponse
extends AbstractMutableMessage<MutableResponse>
implements Response,
Response.Builder {
    private transient javax.ws.rs.core.Response jaxrsView;
    private transient Response.ResponseBuilder jaxrsBuilderView;
    private transient ResponseHeaders jaxrsHeadersView;
    private Response.StatusType status;

    public MutableResponse() {
        this.status = Response.Status.NO_CONTENT;
    }

    public MutableResponse(MutableResponse that) {
        super(that);
        this.status = that.status;
    }

    MutableResponse(Response.StatusType status, MessageBodyWorkers workers) {
        this.status = status;
        this.entityWorkers(workers);
    }

    MutableResponse(int statusCode, MessageBodyWorkers workers) {
        this.status = Statuses.from(statusCode);
        this.entityWorkers(workers);
    }

    @Override
    public Response.StatusType status() {
        return this.status;
    }

    @Override
    public MutableResponse status(Response.StatusType status) {
        this.status = status;
        return this;
    }

    @Override
    public MutableResponse status(int statusCode) {
        this.status = Statuses.from(statusCode);
        return this;
    }

    @Override
    public MutableResponse clone() {
        return new MutableResponse(this);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public javax.ws.rs.core.Response toJaxrsResponse() {
        if (this.jaxrsView == null) {
            this.jaxrsView = new JaxrsResponseView(this);
        }
        return this.jaxrsView;
    }

    @Override
    public Response.ResponseBuilder toJaxrsResponseBuilder() {
        if (this.jaxrsBuilderView == null) {
            this.jaxrsBuilderView = new JaxrsResponseBuilderView(this);
        }
        return this.jaxrsBuilderView;
    }

    @Override
    public ResponseHeaders getJaxrsHeaders() {
        if (this.jaxrsHeadersView == null) {
            this.jaxrsHeadersView = new JaxrsResponseHeadersView(this);
        }
        return this.jaxrsHeadersView;
    }

    @Override
    public boolean isEntityRetrievable() {
        return this.isEmpty() || this.type() != null;
    }

    @Override
    public Response.Builder workers(MessageBodyWorkers workers) {
        this.entityWorkers(workers);
        return this;
    }

    @Override
    public MessageBodyWorkers workers() {
        return this.entityWorkers();
    }
}

