/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Configuration;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.Services;
import org.glassfish.jersey.internal.ServiceProviders;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.glassfish.jersey.process.internal.PriorityComparator;
import org.jvnet.hk2.annotations.Inject;

public abstract class AbstractFilterProcessor<T> {
    private PriorityComparator.Order order;
    @Inject
    private Services services;
    @Inject
    protected Factory<JerseyFilterContext> filterContextFactory;

    protected AbstractFilterProcessor() {
        this.order = PriorityComparator.Order.ASCENDING;
    }

    protected AbstractFilterProcessor(PriorityComparator.Order order) {
        this.order = order;
    }

    protected final List<T> getFilters(Class<T> filterContract) {
        ServiceProviders serviceProviders = (ServiceProviders)this.services.forContract(ServiceProviders.class).get();
        return serviceProviders.getAll(filterContract, new PriorityComparator(this.order));
    }

    protected final Map<String, Object> getProperties() {
        Configuration config = (Configuration)this.services.forContract(Configuration.class).get();
        return config != null ? config.getProperties() : null;
    }
}

