/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableAcceptor;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.RequestFilterProcessor;
import org.glassfish.jersey.process.internal.ResponseFilterProcessor;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stages;
import org.jvnet.hk2.annotations.Inject;

public class FilteringAcceptor
extends AbstractChainableAcceptor {
    private final RequestFilterProcessor requestFilterProcessor;
    private final ResponseFilterProcessor responseFilterProcessor;
    private final Factory<JerseyFilterContext> filterContextFactory;
    private final Factory<ResponseProcessor.RespondingContext> respondingContextFactory;

    public FilteringAcceptor(@Inject RequestFilterProcessor requestFilterProcessor, @Inject ResponseFilterProcessor responseFilterProcessor, @Inject Factory<JerseyFilterContext> filterContextFactory, @Inject Factory<ResponseProcessor.RespondingContext> respondingContextFactory) {
        this.requestFilterProcessor = requestFilterProcessor;
        this.responseFilterProcessor = responseFilterProcessor;
        this.filterContextFactory = filterContextFactory;
        this.respondingContextFactory = respondingContextFactory;
    }

    @Override
    public Pair<Request, Optional<LinearAcceptor>> apply(Request request) {
        JerseyFilterContext filterContext = (JerseyFilterContext)this.filterContextFactory.get();
        ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push(this.responseFilterProcessor);
        filterContext.setResponse(null);
        Request filteredRequest = this.requestFilterProcessor.apply(request);
        final Response filterContextResponse = filterContext.getResponse();
        if (filterContextResponse == null) {
            return Tuples.of(filteredRequest, this.getDefaultNext());
        }
        return Tuples.of(filteredRequest, Optional.of((Object)Stages.asLinearAcceptor(new Inflector<Request, Response>(){

            @Override
            public Response apply(Request request) {
                return filterContextResponse;
            }
        })));
    }
}

