/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.LinearAcceptor;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.Stages;

public class LinearRequestProcessor
implements RequestProcessor {
    private final LinearAcceptor rootAcceptor;

    public LinearRequestProcessor(LinearAcceptor rootAcceptor) {
        this.rootAcceptor = rootAcceptor;
    }

    @Override
    public Pair<Request, Optional<Inflector<Request, Response>>> apply(Request request) {
        Optional currentStage = Optional.fromNullable((Object)this.rootAcceptor);
        Pair<Request, Optional> continuation = Tuples.of(request, currentStage);
        Optional lastStage = Optional.absent();
        while (currentStage.isPresent()) {
            lastStage = currentStage;
            continuation = ((LinearAcceptor)currentStage.get()).apply(continuation.left());
            currentStage = continuation.right();
        }
        Request processed = continuation.left();
        Preconditions.checkState((boolean)lastStage.isPresent(), (Object)"No stage has been invoked as part of the processing.");
        return Tuples.of(processed, Stages.extractInflector(lastStage.get()));
    }
}

