/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingExecutorsFactory;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.jvnet.hk2.annotations.Inject;

public class RequestInvoker {
    private static final InvocationCallback EMPTY_CALLBACK = new InvocationCallback(){

        @Override
        public void result(Response response) {
        }

        @Override
        public void failure(Throwable exception) {
        }

        @Override
        public void suspended(long time, TimeUnit unit, InvocationContext context) {
        }

        @Override
        public void suspendTimeoutChanged(long time, TimeUnit unit) {
        }

        @Override
        public void resumed() {
        }

        @Override
        public void cancelled() {
        }
    };
    private final RequestProcessor requestProcessor;
    private final RequestScope requestScope;
    private final ResponseProcessor.Builder responseProcessorBuilder;
    private final Factory<Ref<InvocationContext>> invocationContextReferenceFactory;
    private final ProcessingExecutorsFactory executorsFactory;

    private RequestInvoker(RequestProcessor requestProcessor, RequestScope requestScope, ResponseProcessor.Builder responseProcessorBuilder, Factory<Ref<InvocationContext>> invocationContextReferenceFactory, ProcessingExecutorsFactory executorsFactory) {
        this.requestScope = requestScope;
        this.requestProcessor = requestProcessor;
        this.responseProcessorBuilder = responseProcessorBuilder;
        this.invocationContextReferenceFactory = invocationContextReferenceFactory;
        this.executorsFactory = executorsFactory;
    }

    public ListenableFuture<Response> apply(Request request) {
        return this.apply(request, EMPTY_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Response> apply(final Request request, final InvocationCallback callback) {
        final RequestScope.Instance instance = this.requestScope.suspendCurrent();
        final ResponseProcessor responseProcessor = this.responseProcessorBuilder.build(callback, instance);
        final Runnable requester = new Runnable(){

            @Override
            public void run() {
                AsyncInflectorAdapter asyncInflector = new AsyncInflectorAdapter(new AcceptingInvoker(), callback);
                ((Ref)RequestInvoker.this.invocationContextReferenceFactory.get()).set(asyncInflector);
                ListenableFuture<Response> response = asyncInflector.apply(request);
                response.addListener((Runnable)responseProcessor, (Executor)RequestInvoker.this.executorsFactory.getRespondingExecutor());
            }
        };
        try {
            try {
                this.executorsFactory.getRequestingExecutor().submit(new Runnable(){

                    @Override
                    public void run() {
                        RequestInvoker.this.requestScope.runInScope(instance, requester);
                    }
                });
                return responseProcessor;
            }
            catch (RejectedExecutionException ex) {
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_FAILED(), ex);
            }
        }
        catch (ProcessingException ex) {
            try {
                SettableFuture failedResponse = SettableFuture.create();
                failedResponse.setException((Throwable)ex);
                SettableFuture settableFuture = failedResponse;
                return settableFuture;
            }
            finally {
                callback.failure(ex);
            }
        }
    }

    private class AcceptingInvoker
    implements Inflector<Request, Response> {
        private AcceptingInvoker() {
        }

        @Override
        public Response apply(Request request) {
            Pair<Request, Optional<Inflector<Request, Response>>> result;
            try {
                result = RequestInvoker.this.requestProcessor.apply(request);
            }
            catch (WebApplicationException wae) {
                result = Tuples.of(request, Optional.of((Object)new Inflector<Request, Response>(){

                    @Override
                    public Response apply(Request data) {
                        return wae.getResponse();
                    }
                }));
            }
            Optional<Inflector<Request, Response>> inflector = result.right();
            if (!inflector.isPresent()) {
                throw new InflectorNotFoundException("Terminal stage did not provide an inflector");
            }
            return (Response)((Inflector)inflector.get()).apply(result.left());
        }
    }

    public static final class Builder {
        @Inject
        private RequestScope requestScope;
        @Inject
        private ResponseProcessor.Builder responseProcessorBuilder;
        @Inject
        private Factory<Ref<InvocationContext>> invocationContextReferenceFactory;
        @Inject
        private ProcessingExecutorsFactory executorsFactory;

        public RequestInvoker build(RequestProcessor requestProcessor) {
            return new RequestInvoker(requestProcessor, this.requestScope, this.responseProcessorBuilder, this.invocationContextReferenceFactory, this.executorsFactory);
        }
    }
}

