/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import org.glassfish.hk2.ComponentException;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;

public abstract class ReferencingFactory<T>
implements Factory<T> {
    private final Factory<Ref<T>> referenceFactory;

    public ReferencingFactory(Factory<Ref<T>> referenceFactory) {
        this.referenceFactory = referenceFactory;
    }

    public T get() throws ComponentException {
        return ((Ref)this.referenceFactory.get()).get();
    }

    public static <T> Factory<Ref<T>> referenceFactory() {
        return new EmptyReferenceFactory();
    }

    public static <T> Factory<Ref<T>> referenceFactory(T initialValue) {
        if (initialValue == null) {
            return new EmptyReferenceFactory();
        }
        return new InitializedReferenceFactory<T>(initialValue);
    }

    private static class InitializedReferenceFactory<T>
    implements Factory<Ref<T>> {
        private final T initialValue;

        public InitializedReferenceFactory(T initialValue) {
            this.initialValue = initialValue;
        }

        public Ref<T> get() throws ComponentException {
            return Refs.of(this.initialValue);
        }
    }

    private static class EmptyReferenceFactory<T>
    implements Factory<Ref<T>> {
        private EmptyReferenceFactory() {
        }

        public Ref<T> get() throws ComponentException {
            return Refs.emptyRef();
        }
    }
}

