/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.AbstractMultivaluedMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.message.internal.Headers;
import org.glassfish.jersey.message.internal.HeadersFactory;

class MutableHeaders
implements Headers,
Headers.Builder<MutableHeaders> {
    private final AbstractMultivaluedMap<String, String> stringHeaders = HeadersFactory.createInbound();
    private final AbstractMultivaluedMap<String, Object> objectHeaders = HeadersFactory.createOutbound();

    public MutableHeaders() {
    }

    public MutableHeaders(MutableHeaders that) {
        this();
        this.stringHeaders.putAll(that.stringHeaders);
        this.objectHeaders.putAll(that.objectHeaders);
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headerValues(name);
        if (headers == null) {
            return null;
        }
        Iterator<String> values = this.headerValues(name).iterator();
        if (!values.hasNext()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder(values.next());
        while (values.hasNext()) {
            buffer.append(',').append(values.next());
        }
        return buffer.toString();
    }

    @Override
    public MultivaluedMap<String, String> headers() {
        this.fetchAll();
        return this.stringHeaders;
    }

    @Override
    public List<String> headerValues(String name) {
        this.fetch(name);
        return this.stringHeaders.get((Object)name);
    }

    @Override
    public MutableHeaders header(String name, Object value) {
        this.objectHeaders.add((Object)name, value);
        return this;
    }

    @Override
    public MutableHeaders header(String name, String value) {
        this.stringHeaders.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public MutableHeaders headers(String name, Object ... values) {
        this.objectHeaders.addAll((Object)name, values);
        return this;
    }

    @Override
    public MutableHeaders headers(String name, String ... values) {
        this.stringHeaders.addAll((Object)name, (Object[])values);
        return this;
    }

    @Override
    public MutableHeaders headers(String name, Iterable<? extends Object> values) {
        this.objectHeaders.addAll((Object)name, this.iterableToList(values));
        return this;
    }

    @Override
    public MutableHeaders headers(MultivaluedMap<String, ? extends Object> headers) {
        this.objectHeaders.putAll(headers);
        return this;
    }

    @Override
    public MutableHeaders headers(Map<String, List<String>> headers) {
        this.stringHeaders.putAll(HeadersFactory.createInbound(headers));
        return this;
    }

    @Override
    public MutableHeaders remove(String name) {
        this.objectHeaders.remove((Object)name);
        this.stringHeaders.remove((Object)name);
        return this;
    }

    @Override
    public MutableHeaders replace(String name, Iterable<? extends Object> values) {
        this.stringHeaders.remove((Object)name);
        this.objectHeaders.put((Object)name, this.iterableToList(values));
        return this;
    }

    @Override
    public MutableHeaders replaceAll(MultivaluedMap<String, String> headers) {
        this.objectHeaders.clear();
        this.stringHeaders.clear();
        this.stringHeaders.putAll(headers);
        return this;
    }

    private void fetch(String headerName) {
        if (this.objectHeaders.isEmpty()) {
            return;
        }
        List values = this.objectHeaders.remove((Object)headerName);
        if (values == null || values.isEmpty()) {
            return;
        }
        this.stringHeaders.addAll((Object)headerName, HeadersFactory.toString(values, RuntimeDelegate.getInstance()));
    }

    private void fetchAll() {
        if (!this.objectHeaders.isEmpty()) {
            this.stringHeaders.putAll(HeadersFactory.toString(this.objectHeaders, RuntimeDelegate.getInstance()));
            this.objectHeaders.clear();
        }
    }

    private List<Object> iterableToList(Iterable<? extends Object> values) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : values) {
            linkedList.add(object);
        }
        return linkedList;
    }
}

