/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.JerseyFilterContext;
import org.glassfish.jersey.process.internal.RequestFilterProcessor;
import org.glassfish.jersey.process.internal.ResponseFilterProcessor;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;
import org.jvnet.hk2.annotations.Inject;

public class FilteringStage
extends AbstractChainableStage<Request> {
    private final RequestFilterProcessor requestFilterProcessor;
    private final ResponseFilterProcessor responseFilterProcessor;
    private final Factory<JerseyFilterContext> filterContextFactory;
    private final Factory<ResponseProcessor.RespondingContext<Response>> respondingContextFactory;

    public FilteringStage(@Inject RequestFilterProcessor requestFilterProcessor, @Inject ResponseFilterProcessor responseFilterProcessor, @Inject Factory<JerseyFilterContext> filterContextFactory, @Inject Factory<ResponseProcessor.RespondingContext<Response>> respondingContextFactory) {
        this.requestFilterProcessor = requestFilterProcessor;
        this.responseFilterProcessor = responseFilterProcessor;
        this.filterContextFactory = filterContextFactory;
        this.respondingContextFactory = respondingContextFactory;
    }

    @Override
    public Stage.Continuation<Request> apply(Request request) {
        JerseyFilterContext filterContext = (JerseyFilterContext)this.filterContextFactory.get();
        ((ResponseProcessor.RespondingContext)this.respondingContextFactory.get()).push(this.responseFilterProcessor);
        filterContext.setResponse(null);
        Request filteredRequest = this.requestFilterProcessor.apply(request);
        final Response filterContextResponse = filterContext.getResponse();
        if (filterContextResponse == null) {
            return Stage.Continuation.of(filteredRequest, this.getDefaultNext());
        }
        return Stage.Continuation.of(filteredRequest, Stages.asStage(new Inflector<Request, Response>(){

            @Override
            public Response apply(Request request) {
                return filterContextResponse;
            }
        }));
    }
}

