/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.Factory;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.MappableException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.jvnet.hk2.annotations.Inject;

public abstract class ResponseProcessor<DATA>
extends AbstractFuture<DATA>
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ResponseProcessor.class.getName());
    private final RequestScope requestScope;
    private volatile RequestScope.Instance scopeInstance;
    private final InvocationCallback<DATA> callback;
    private final Future<DATA> inflectedResponse;
    private final Factory<RespondingContext<DATA>> respondingCtxProvider;
    private final Factory<ExceptionMappers> exceptionMappersProvider;

    private ResponseProcessor(InvocationCallback<DATA> callback, Future<DATA> inflectedResponse, Factory<RespondingContext<DATA>> respondingCtxProvider, RequestScope.Instance scopeInstance, RequestScope requestScope, Factory<ExceptionMappers> exceptionMappersProvider) {
        this.requestScope = requestScope;
        this.scopeInstance = scopeInstance;
        this.callback = callback;
        this.inflectedResponse = inflectedResponse;
        this.respondingCtxProvider = respondingCtxProvider;
        this.exceptionMappersProvider = exceptionMappersProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.requestScope.runInScope(this.scopeInstance, new Runnable(){

                @Override
                public void run() {
                    Object response;
                    block11: {
                        if (ResponseProcessor.this.inflectedResponse.isCancelled()) {
                            ResponseProcessor.super.cancel(true);
                            return;
                        }
                        try {
                            response = ResponseProcessor.this.inflectedResponse.get();
                        }
                        catch (Exception ex) {
                            Throwable unwrapped = ex instanceof ExecutionException ? ex.getCause() : ex;
                            LOGGER.log(Level.FINE, "Request-to-response transformation finished with an exception.", unwrapped);
                            try {
                                response = ResponseProcessor.this.convertResponse(ResponseProcessor.this.mapException(unwrapped));
                            }
                            catch (Exception ex2) {
                                ResponseProcessor.this.setResult(ex2);
                                return;
                            }
                            if (response != null) break block11;
                            ResponseProcessor.this.setResult(unwrapped);
                            return;
                        }
                    }
                    for (int i = 0; i < 2; ++i) {
                        try {
                            response = ResponseProcessor.this.runResponders(response);
                            break;
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.FINE, "Responder chain execution finished with an exception.", ex);
                            if (i == 0) {
                                try {
                                    response = ResponseProcessor.this.convertResponse(ResponseProcessor.this.mapException(ex));
                                }
                                catch (Exception ex2) {
                                    ResponseProcessor.this.setResult(ex2);
                                    return;
                                }
                            }
                            if (response != null) continue;
                            ResponseProcessor.this.setResult(ex);
                            return;
                        }
                    }
                    ResponseProcessor.this.setResult(response);
                }
            });
        }
        finally {
            this.scopeInstance.release();
        }
    }

    private DATA runResponders(DATA response) {
        Stage responder = ((RespondingContext)this.respondingCtxProvider.get()).createResponderRoot();
        if (responder != null) {
            Stage.Continuation<DATA> continuation = Stage.Continuation.of(response, responder);
            while (continuation.hasNext()) {
                continuation = continuation.next().apply(continuation.result());
            }
            return continuation.result();
        }
        return response;
    }

    protected abstract DATA convertResponse(Response var1);

    private Response mapException(Throwable exception) throws Exception {
        ExceptionMapper<?> mapper;
        Response response = null;
        if (exception instanceof MappableException) {
            exception = exception.getCause();
        }
        if (exception instanceof WebApplicationException) {
            response = ((WebApplicationException)exception).getResponse();
        }
        ExceptionMappers exceptionMappers = (ExceptionMappers)this.exceptionMappersProvider.get();
        if (!(response != null && response.hasEntity() || exceptionMappers == null || (mapper = exceptionMappers.find(exception.getClass())) == null)) {
            response = mapper.toResponse(exception);
        }
        return response;
    }

    private void setResult(DATA response) {
        super.set(response);
        this.notifyCallback(response);
    }

    private void setResult(Throwable exception) {
        super.setException(exception);
        this.notifyCallback(exception);
    }

    private void notifyCallback(DATA response) {
        try {
            this.callback.result(response);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("result"), ex);
        }
    }

    private void notifyCallback(Throwable exception) {
        try {
            this.callback.failure(exception);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.CALLBACK_METHOD_INVOCATION_FAILED("failure"), ex);
        }
    }

    public static class ResponseBuilder
    implements Builder<Response> {
        @Inject
        private RequestScope requestScope;
        @Inject
        private Factory<RespondingContext<Response>> respondingCtxProvider;
        @Inject
        private Factory<ExceptionMappers> exceptionMappersProvider;

        @Override
        public ResponseProcessor<Response> build(Future<Response> inflectedResponse, InvocationCallback<Response> callback, RequestScope.Instance scopeInstance) {
            return new ResponseProcessor<Response>(callback, inflectedResponse, this.respondingCtxProvider, scopeInstance, this.requestScope, this.exceptionMappersProvider){

                @Override
                protected Response convertResponse(Response exceptionResponse) {
                    return exceptionResponse;
                }
            };
        }
    }

    public static interface Builder<DATA> {
        public ResponseProcessor<DATA> build(Future<DATA> var1, InvocationCallback<DATA> var2, RequestScope.Instance var3);
    }

    public static interface RespondingContext<DATA> {
        public void push(Function<DATA, DATA> var1);

        public Stage<DATA> createResponderRoot();
    }
}

