/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.net.URI;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.AcceptableToken;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.Headers;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.message.internal.MatchingEntityTag;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.QualitySourceMediaType;

final class HttpHelper {
    public static int getContentLength(Headers headers) {
        String value = headers.header("Content-Length");
        try {
            return value != null && value.length() > 0 ? Integer.parseInt(value) : -1;
        }
        catch (NumberFormatException ex) {
            throw HttpHelper.exception("Content-Length", value, ex);
        }
    }

    public static MediaType getContentType(Headers headers) {
        List<String> vs = headers.headerValues("Content-Type");
        return vs != null && vs.size() > 0 ? HttpHelper.getContentType(vs.get(0)) : null;
    }

    public static MediaType getContentType(String contentTypeString) {
        try {
            return contentTypeString != null ? MediaType.valueOf((String)contentTypeString) : null;
        }
        catch (IllegalArgumentException e) {
            throw HttpHelper.exception("Content-Type", contentTypeString, e);
        }
    }

    public static MediaType getContentType(Object contentType) {
        if (contentType == null) {
            return null;
        }
        if (contentType instanceof MediaType) {
            return (MediaType)contentType;
        }
        return MediaType.valueOf((String)contentType.toString());
    }

    public static Locale getContentLanguageAsLocale(Headers headers) {
        List<String> vs = headers.headerValues("Content-Language");
        return vs != null && vs.size() > 0 ? HttpHelper.getLanguageTagAsLocale(vs.get(0)) : null;
    }

    public static Locale getLanguageTagAsLocale(String language) {
        if (language == null) {
            return null;
        }
        try {
            return new LanguageTag(language).getAsLocale();
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Content-Language", language, e);
        }
    }

    public static Date getDate(Headers headers) {
        String date = headers.header("Date");
        try {
            return date == null ? null : HttpHeaderReader.readDate(date);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Date", date, e);
        }
    }

    public static Set<MatchingEntityTag> getIfMatch(Headers headers) {
        String ifMatch = headers.header("If-Match");
        if (ifMatch == null || ifMatch.length() == 0) {
            return null;
        }
        try {
            return HttpHeaderReader.readMatchingEntityTag(ifMatch);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("If-Match", ifMatch, e);
        }
    }

    public static Set<MatchingEntityTag> getIfNoneMatch(Headers headers) {
        String ifNoneMatch = headers.header("If-None-Match");
        if (ifNoneMatch == null || ifNoneMatch.length() == 0) {
            return null;
        }
        try {
            return HttpHeaderReader.readMatchingEntityTag(ifNoneMatch);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("If-None-Match", ifNoneMatch, e);
        }
    }

    public static List<AcceptableMediaType> getAccept(Headers headers) {
        String accept = headers.header("Accept");
        if (accept == null || accept.length() == 0) {
            return MediaTypes.GENERAL_ACCEPT_MEDIA_TYPE_LIST;
        }
        try {
            return HttpHeaderReader.readAcceptMediaType(accept);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Accept", accept, e);
        }
    }

    public static List<AcceptableMediaType> getAccept(Headers headers, List<QualitySourceMediaType> priorityMediaTypes) {
        String accept = headers.header("Accept");
        if (accept == null || accept.length() == 0) {
            return MediaTypes.GENERAL_ACCEPT_MEDIA_TYPE_LIST;
        }
        try {
            return HttpHeaderReader.readAcceptMediaType(accept, priorityMediaTypes);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Accept", accept, e);
        }
    }

    public static List<AcceptableLanguageTag> getAcceptLanguage(Headers headers) {
        String acceptLanguage = headers.header("Accept-Language");
        if (acceptLanguage == null || acceptLanguage.length() == 0) {
            return Collections.singletonList(new AcceptableLanguageTag("*", null));
        }
        try {
            return HttpHeaderReader.readAcceptLanguage(acceptLanguage);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Accept-Language", acceptLanguage, e);
        }
    }

    public static List<AcceptableToken> getAcceptCharset(Headers headers) {
        String acceptCharset = headers.header("Accept-Charset");
        try {
            if (acceptCharset == null || acceptCharset.length() == 0) {
                return Collections.singletonList(new AcceptableToken("*"));
            }
            return HttpHeaderReader.readAcceptToken(acceptCharset);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Accept-Charset", acceptCharset, e);
        }
    }

    public static List<AcceptableToken> getAcceptEncoding(Headers headers) {
        String acceptEncoding = headers.header("Accept-Encoding");
        try {
            if (acceptEncoding == null || acceptEncoding.length() == 0) {
                return Collections.singletonList(new AcceptableToken("*"));
            }
            return HttpHeaderReader.readAcceptToken(acceptEncoding);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Accept-Encoding", acceptEncoding, e);
        }
    }

    private static HeaderValueException exception(String headerName, Object headerValue, Exception e) {
        return new HeaderValueException(LocalizationMessages.UNABLE_TO_PARSE_HEADER_VALUE(headerName, headerValue), e);
    }

    public static boolean produces(MediaType contentType, List<MediaType> accept) {
        for (MediaType a : accept) {
            if (a.getType().equals("*")) {
                return true;
            }
            if (!contentType.isCompatible(a)) continue;
            return true;
        }
        return false;
    }

    public static Set<String> getAllowedMethods(Headers headers) {
        String allowed = headers.header("Allow");
        if (allowed == null || allowed.length() == 0) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<String>(HttpHeaderReader.readStringList(allowed));
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Allow", allowed, e);
        }
    }

    public static Set<Link> getLinks(Headers headers) {
        List<String> links = headers.headerValues("Link");
        if (links == null || links.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<Link> result = new HashSet<Link>(links.size());
            for (String l : links) {
                result.add(Link.valueOf((String)l));
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw HttpHelper.exception("Link", links, e);
        }
    }

    public static Map<String, Cookie> getCookies(Headers headers) {
        List<String> cookies = headers.headerValues("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> result = new HashMap<String, Cookie>();
        for (String cookie : cookies) {
            if (cookie == null) continue;
            result.putAll(HttpHeaderReader.readCookies(cookie));
        }
        return result;
    }

    public static Map<String, NewCookie> getNewCookies(Headers headers) {
        List<String> cookies = headers.headerValues("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>();
        for (String cookie : cookies) {
            if (cookie == null) continue;
            NewCookie newCookie = HttpHeaderReader.readNewCookie(cookie);
            result.put(newCookie.getName(), newCookie);
        }
        return result;
    }

    public static EntityTag getEntityTag(Headers headers) {
        String value = headers.header("ETag");
        try {
            return value == null ? null : EntityTag.valueOf((String)value);
        }
        catch (IllegalArgumentException ex) {
            throw HttpHelper.exception("ETag", value, ex);
        }
    }

    public static Date getLastModified(Headers headers) {
        String value = headers.header("Last-Modified");
        try {
            return value == null ? null : HttpHeaderReader.readDate(value);
        }
        catch (ParseException e) {
            throw HttpHelper.exception("Last-Modified", value, e);
        }
    }

    public static URI getLocation(Headers headers) {
        String value = headers.header("Location");
        try {
            return value == null ? null : URI.create(value);
        }
        catch (IllegalArgumentException ex) {
            throw HttpHelper.exception("Location", value, ex);
        }
    }

    private HttpHelper() {
    }
}

