/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MessageProcessingException;
import javax.xml.transform.Source;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AbstractMutableMessage;
import org.glassfish.jersey.message.internal.Entity;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.jvnet.hk2.annotations.Inject;

class MutableEntity
implements Entity,
Entity.Builder<MutableEntity> {
    private static final Logger LOGGER = Logger.getLogger(MutableEntity.class.getName());
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final InputStream EMPTY = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private GenericEntity<?> genericEntity;
    private AbstractMutableMessage<?> message;
    private Annotation[] writeAnnotations = EMPTY_ANNOTATIONS;
    @Inject
    protected MessageBodyWorkers workers;
    private ContentStream contentStream;

    public static MutableEntity empty(AbstractMutableMessage<?> message) {
        return new MutableEntity(message, EMPTY);
    }

    public MutableEntity(AbstractMutableMessage<?> message, InputStream content) {
        this.message = message;
        this.contentStream = new ContentStream(content);
    }

    public MutableEntity(AbstractMutableMessage<?> message, GenericEntity<?> genericEntity) {
        this.message = message;
        this.genericEntity = genericEntity;
    }

    public MutableEntity(AbstractMutableMessage<?> message, MutableEntity that) {
        this.message = message;
        this.genericEntity = that.genericEntity;
        this.workers = that.workers;
    }

    @Override
    public boolean isEmpty() {
        if (this.contentStream == null || this.contentStream.getInputStream() == null) {
            return this.genericEntity == null;
        }
        return this.contentStream.isEmpty();
    }

    @Override
    public MutableEntity writeAnnotations(Annotation[] annotations) {
        this.writeAnnotations = Arrays.copyOf(annotations, annotations.length);
        return this;
    }

    @Override
    public Object content() {
        return this.content(Object.class);
    }

    @Override
    public <T> T content(Class<T> rawType) {
        return this.content(rawType, this.extractType(rawType), EMPTY_ANNOTATIONS);
    }

    @Override
    public <T> T content(GenericType<T> type) {
        return this.content(type.getRawType(), type.getType(), EMPTY_ANNOTATIONS);
    }

    @Override
    public <T> T content(Class<T> rawType, Annotation[] annotations) {
        return this.content(rawType, this.extractType(rawType), annotations);
    }

    @Override
    public <T> T content(GenericType<T> type, Annotation[] annotations) {
        return this.content(type.getRawType(), type.getType(), annotations);
    }

    private <T> T content(Class<T> rawType, Type type, Annotation[] readAnnotations) {
        boolean typeIsAssignableFromMyInstance;
        if (this.isEmpty()) {
            return null;
        }
        boolean bl = typeIsAssignableFromMyInstance = this.genericEntity != null && rawType.isAssignableFrom(this.genericEntity.getRawType());
        if (typeIsAssignableFromMyInstance) {
            return rawType.cast(this.genericEntity.getEntity());
        }
        if (this.genericEntity != null && this.contentStream.getType() != ContentStream.Type.BUFFERED && this.contentStream.getType() != ContentStream.Type.EXTERNAL_BUFFERED) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.bufferEntityInstance(baos)) {
                return null;
            }
            this.contentStream.setBufferedTempContentStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        if (this.workers == null) {
            return null;
        }
        MediaType mediaType = this.getMsgContentType();
        try {
            Object t = this.workers.readFrom(GenericType.of(rawType, (Type)type), readAnnotations, mediaType, this.message.headers(), this.message.properties(), this.contentStream.getInputStream(), this.contentStream.getType().intercept());
            if (this.contentStream.getType() == ContentStream.Type.BUFFERED || this.contentStream.getType() == ContentStream.Type.EXTERNAL_BUFFERED) {
                this.contentStream.getInputStream().reset();
            } else if (!(t instanceof Closeable) && !(t instanceof Source)) {
                this.contentStream.invalidateContentStream();
            }
            this.genericEntity = new GenericEntity<T>(t){};
            return (T)t;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Error reading entity from input stream", ex);
            return null;
        }
    }

    private MediaType getMsgContentType() {
        if (this.message == null) {
            return null;
        }
        String result = this.message.header("Content-Type");
        if (result == null || result.isEmpty()) {
            return MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return MediaType.valueOf((String)result);
    }

    @Override
    public Type type() {
        if (this.genericEntity != null) {
            return this.genericEntity.getType();
        }
        return null;
    }

    @Override
    public MutableEntity content(Object content) {
        if (content instanceof InputStream) {
            this.genericEntity = null;
            this.contentStream.setNewContentStream((InputStream)InputStream.class.cast(content));
            return this;
        }
        this.contentStream.invalidateContentStream();
        this.genericEntity = content != null ? (content instanceof GenericEntity ? (GenericEntity)content : new GenericEntity(content, this.extractType(content))) : null;
        return this;
    }

    public void rawEntityStream(InputStream inputStream) {
        this.contentStream.setExternalContentStream(inputStream);
    }

    @Override
    public MutableEntity content(Object content, Type type) {
        this.contentStream.invalidateContentStream();
        this.genericEntity = content != null ? new GenericEntity(content, type) : null;
        return this;
    }

    @Override
    public <T> MutableEntity content(Object content, GenericType<T> type) {
        this.contentStream.invalidateContentStream();
        this.genericEntity = content != null ? new GenericEntity(content, type.getType()) : null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferEntity() throws MessageProcessingException {
        try {
            if (this.isEmpty() || this.contentStream.getType() == ContentStream.Type.BUFFERED || this.contentStream.getType() == ContentStream.Type.EXTERNAL_BUFFERED) {
                return;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.contentStream.getInputStream() != null) {
                try {
                    ReaderWriter.writeTo(this.contentStream.getInputStream(), baos);
                }
                finally {
                    this.contentStream.invalidateContentStream();
                }
            } else if (this.bufferEntityInstance(baos)) {
                return;
            }
            this.contentStream.setBufferedContentStream(new ByteArrayInputStream(baos.toByteArray()));
        }
        catch (IOException ex) {
            throw new MessageProcessingException(LocalizationMessages.MESSAGE_CONTENT_BUFFERING_FAILED(), (Throwable)ex);
        }
    }

    private boolean bufferEntityInstance(ByteArrayOutputStream baos) {
        Type myInstanceType = this.genericEntity.getType();
        Object myInstance = this.genericEntity.getEntity();
        if (myInstanceType == null || this.workers == null || myInstance == null) {
            return true;
        }
        MediaType mediaType = this.getMsgContentType();
        try {
            this.workers.writeTo(myInstance, GenericType.of((Class)this.genericEntity.getRawType(), (Type)this.genericEntity.getType()), this.writeAnnotations, mediaType, this.message.headers(), this.message.properties(), baos, null, false);
            baos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(MutableEntity.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WebApplicationException ex) {
            Logger.getLogger(MutableEntity.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    @Override
    public boolean isEntityRetrievable() {
        return !this.isEmpty() && this.type() != null;
    }

    public MutableEntity workers(MessageBodyWorkers workers) {
        this.workers = workers;
        return this;
    }

    public MessageBodyWorkers workers() {
        return this.workers;
    }

    private Type extractType(Object fromObject) {
        Class<?> rawType = fromObject.getClass();
        return this.extractType(rawType);
    }

    private Type extractType(Class<? extends Object> fromRawType) {
        Class<? extends Object> genericSuperclass = fromRawType.getGenericSuperclass();
        Class<? extends Object> type = genericSuperclass instanceof ParameterizedType ? genericSuperclass : fromRawType;
        return type;
    }

    private static class ContentStream {
        private InputStream contentStream;
        private Type type;

        public ContentStream(InputStream contentStream) {
            this.contentStream = contentStream;
            this.type = Type.INTERNAL;
        }

        public void setBufferedContentStream(InputStream bufferedInputStream) {
            this.contentStream = bufferedInputStream;
            this.type = this.type == Type.EXTERNAL ? Type.EXTERNAL_BUFFERED : Type.BUFFERED;
        }

        public void setBufferedTempContentStream(InputStream inputStream) {
            this.contentStream = inputStream;
            this.type = Type.TEMP_BUFFERED;
        }

        public void setNewContentStream(InputStream contentStream) {
            this.contentStream = contentStream;
            this.type = Type.INTERNAL;
        }

        public void setExternalContentStream(InputStream contentStream) {
            this.contentStream = contentStream;
            this.type = Type.EXTERNAL;
        }

        public InputStream getInputStream() {
            return this.contentStream;
        }

        public Type getType() {
            return this.type;
        }

        public void invalidateContentStream() {
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), ex);
                }
                this.contentStream = null;
            }
        }

        public boolean isEmpty() {
            if (this.contentStream == null) {
                return true;
            }
            try {
                PushbackInputStream pbis;
                if (this.contentStream.available() > 0) {
                    return false;
                }
                if (this.contentStream.markSupported()) {
                    this.contentStream.mark(1);
                    int i = this.contentStream.read();
                    this.contentStream.reset();
                    return i == -1;
                }
                int b = this.contentStream.read();
                if (b == -1) {
                    return true;
                }
                if (this.contentStream instanceof PushbackInputStream) {
                    pbis = (PushbackInputStream)this.contentStream;
                } else {
                    pbis = new PushbackInputStream(this.contentStream, 1);
                    this.contentStream = pbis;
                }
                pbis.unread(b);
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static enum Type {
            EXTERNAL(true),
            INTERNAL(false),
            BUFFERED(false),
            EXTERNAL_BUFFERED(true),
            TEMP_BUFFERED(false);

            private final boolean intercept;

            private Type(boolean intercept) {
                this.intercept = intercept;
            }

            public boolean intercept() {
                return this.intercept;
            }
        }
    }
}

