/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;
import org.glassfish.hk2.Factory;
import org.glassfish.hk2.scopes.PerThread;
import org.glassfish.jersey.FeaturesAndProperties;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;

@Scoped(value=PerThread.class)
public class SaxParserFactoryInjectionProvider
implements Factory<SAXParserFactory> {
    private static final Logger LOGGER = Logger.getLogger(SaxParserFactoryInjectionProvider.class.getName());
    private final Factory<FeaturesAndProperties> featuresAndPropertiesFactory;

    public SaxParserFactoryInjectionProvider(@Inject Factory<FeaturesAndProperties> featuresAndPropertiesFactory) {
        this.featuresAndPropertiesFactory = featuresAndPropertiesFactory;
    }

    public SAXParserFactory get() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        if (!((FeaturesAndProperties)this.featuresAndPropertiesFactory.get()).isProperty("jersey.config.xml.security.disable")) {
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Security features for the SAX parser could not be enabled", ex);
            }
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "JAXP feature XMLConstants.FEATURE_SECURE_PROCESSING cannot be set on a SAXParserFactory. External general entity processing is disabled but other potential security related features will not be enabled.", ex);
            }
        }
        return factory;
    }
}

