/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Optional;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.TypeLiteral;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Pair;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Tuples;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MessageBodyProcessingException;
import org.glassfish.jersey.message.internal.Requests;
import org.glassfish.jersey.message.internal.Responses;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.FilteringInflector;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.ProcessingExecutorsFactory;
import org.glassfish.jersey.process.internal.RequestProcessor;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.jvnet.hk2.annotations.Inject;

public class RequestInvoker
implements Inflector<Request, ListenableFuture<Response>> {
    private static final InvocationCallback EMPTY_CALLBACK = new InvocationCallback(){

        @Override
        public void result(Response response) {
        }

        @Override
        public void failure(Throwable exception) {
        }

        @Override
        public void suspended(long time, TimeUnit unit, InvocationContext context) {
        }

        @Override
        public void suspendTimeoutChanged(long time, TimeUnit unit) {
        }

        @Override
        public void resumed() {
        }

        @Override
        public void cancelled() {
        }
    };
    @Inject
    private RequestScope requestScope;
    @Inject
    private RequestProcessor requestProcessor;
    @Inject
    private FilteringInflector.Builder filteringInflectorBuilder;
    @Inject
    private ResponseProcessor.Builder responseProcessorBuilder;
    @Inject
    private Services services;
    @Inject
    private ProcessingExecutorsFactory executorsFactory;

    @Override
    public ListenableFuture<Response> apply(Request request) {
        return this.apply(request, EMPTY_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Response> apply(final Request request, final InvocationCallback callback) {
        final RequestScope.Snapshot scopeSnapshot = this.requestScope.takeSnapshot();
        final ResponseProcessor responseProcessor = this.responseProcessorBuilder.build(callback);
        Runnable requester = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (RequestInvoker.this.requestScope.isActive()) {
                    this.runInScope();
                } else {
                    try {
                        RequestInvoker.this.requestScope.enter(scopeSnapshot);
                        this.runInScope();
                    }
                    finally {
                        RequestInvoker.this.requestScope.exit();
                    }
                }
            }

            public void runInScope() {
                MessageBodyWorkers workers = (MessageBodyWorkers)RequestInvoker.this.services.forContract(MessageBodyWorkers.class).get();
                AsyncInflectorAdapter asyncInflector = new AsyncInflectorAdapter(new AcceptingInvoker(workers), callback);
                Ref icRef = (Ref)RequestInvoker.this.services.forContract((TypeLiteral)new TypeLiteral<Ref<InvocationContext>>(){}).get();
                icRef.set(asyncInflector);
                ListenableFuture<Response> response = asyncInflector.apply(request);
                responseProcessor.setRequestScopeSnapshot(RequestInvoker.this.requestScope.takeSnapshot());
                response.addListener((Runnable)responseProcessor, (Executor)RequestInvoker.this.executorsFactory.getRespondingExecutor());
            }
        };
        try {
            try {
                this.executorsFactory.getRequestingExecutor().submit(requester);
                return responseProcessor;
            }
            catch (RejectedExecutionException ex) {
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_FAILED(), ex);
            }
        }
        catch (ProcessingException ex) {
            try {
                SettableFuture failedResponse = SettableFuture.create();
                failedResponse.setException((Throwable)ex);
                SettableFuture settableFuture = failedResponse;
                return settableFuture;
            }
            finally {
                callback.failure(ex);
            }
        }
    }

    private class AcceptingInvoker
    implements Inflector<Request, Response> {
        private final MessageBodyWorkers workers;

        public AcceptingInvoker(MessageBodyWorkers workers) {
            this.workers = workers;
        }

        @Override
        public Response apply(Request request) {
            Pair<Request, Optional<Inflector<Request, Response>>> result;
            Request.RequestBuilder rb = Requests.toBuilder(request);
            Requests.setMessageWorkers(rb, this.workers);
            Request requestWithWorkers = rb.build();
            try {
                result = RequestInvoker.this.requestProcessor.apply(requestWithWorkers);
            }
            catch (MessageBodyProcessingException mbpe) {
                throw mbpe;
            }
            catch (WebApplicationException wae) {
                result = Tuples.of(requestWithWorkers, Optional.of((Object)new Inflector<Request, Response>(){

                    @Override
                    public Response apply(Request data) {
                        return wae.getResponse();
                    }
                }));
            }
            final Optional<Inflector<Request, Response>> inflector = result.right();
            if (!inflector.isPresent()) {
                throw new InflectorNotFoundException("Terminal stage did not provide an inflector");
            }
            Inflector<Request, Response> workersAwareResponseInflector = new Inflector<Request, Response>(){

                @Override
                public Response apply(Request data) {
                    Response originalResponse = (Response)((Inflector)inflector.get()).apply(data);
                    if (originalResponse != null) {
                        Response.ResponseBuilder rb = Responses.toBuilder(originalResponse);
                        Responses.setMessageWorkers(rb, AcceptingInvoker.this.workers);
                        return rb.build();
                    }
                    return null;
                }
            };
            FilteringInflector filteringInflector = RequestInvoker.this.filteringInflectorBuilder.build(workersAwareResponseInflector);
            return filteringInflector.apply(result.left());
        }
    }
}

