/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.Providers;

public class ProviderBinder {
    @Inject
    ServiceLocator locator;

    public <T> void bindInstances(T ... instances) {
        if (instances != null && instances.length > 0) {
            DynamicConfigurationService dcs = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration dc = dcs.createDynamicConfiguration();
            for (T instance : instances) {
                this.bindInstance(instance, dc);
            }
            dc.commit();
        }
    }

    public void bindInstances(Set<Object> instances) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        for (Object instance : instances) {
            this.bindInstance(instance, dc);
        }
        dc.commit();
    }

    public void bindClasses(Class<?> ... classes) {
        if (classes != null && classes.length > 0) {
            DynamicConfigurationService dcs = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
            DynamicConfiguration dc = dcs.createDynamicConfiguration();
            for (Class<?> clazz : classes) {
                this.bindClass(clazz, this.locator, dc, false);
            }
            dc.commit();
        }
    }

    public void bindClasses(Iterable<Class<?>> classes) {
        this.bindClasses(classes, false);
    }

    public void bindClasses(Iterable<Class<?>> classes, boolean bindResources) {
        if (classes == null || !classes.iterator().hasNext()) {
            return;
        }
        DynamicConfigurationService dcs = (DynamicConfigurationService)this.locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        for (Class<?> clazz : classes) {
            this.bindClass(clazz, this.locator, dc, bindResources);
        }
        dc.commit();
    }

    private <T> void bindInstance(T instance, DynamicConfiguration dc) {
        for (Class<?> contract : Providers.getProviderContracts(instance.getClass())) {
            AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor(instance);
            descriptor.addContractType(contract);
            descriptor.addQualifierAnnotation((Annotation)new CustomAnnotationImpl());
            dc.bind((Descriptor)descriptor);
        }
    }

    private <T> void bindClass(Class<T> clazz, ServiceLocator locator, DynamicConfiguration dc, boolean isResource) {
        Class<? extends Annotation> scope = this.getProviderScope(clazz);
        if (isResource) {
            ActiveDescriptor descriptor = dc.bind((Descriptor)BuilderHelper.activeLink(clazz).to(clazz).in(scope).build());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.addQualifierAnnotation((Annotation)new CustomAnnotationImpl());
                dc.bind((Descriptor)aliasDescriptor);
            }
        } else {
            ActiveDescriptorBuilder descriptorBuilder = BuilderHelper.activeLink(clazz).in(scope).qualifiedBy((Annotation)new CustomAnnotationImpl());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                descriptorBuilder.to(contract);
            }
            dc.bind((Descriptor)descriptorBuilder.build());
        }
    }

    private Class<? extends Annotation> getProviderScope(Class<?> clazz) {
        Class<Singleton> hk2Scope = Singleton.class;
        if (clazz.isAnnotationPresent(org.glassfish.jersey.spi.PerLookup.class)) {
            hk2Scope = PerLookup.class;
        }
        return hk2Scope;
    }

    public static class ProviderBinderModule
    extends AbstractModule {
        @Override
        protected void configure() {
            this.bind((Descriptor)BuilderHelper.link(ProviderBinder.class).in(PerLookup.class).build());
        }
    }
}

