/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.base.Preconditions;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.jersey.internal.inject.Module;

public abstract class AbstractModule
implements Module,
DynamicConfiguration {
    private transient DynamicConfiguration configuration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(DynamicConfiguration configuration) {
        Preconditions.checkState((this.configuration == null ? 1 : 0) != 0, (Object)"Recursive configuration call detected.");
        this.configuration = (DynamicConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        try {
            this.configure();
        }
        finally {
            this.configuration = null;
        }
    }

    protected abstract void configure();

    private DynamicConfiguration configuration() {
        Preconditions.checkState((this.configuration != null ? 1 : 0) != 0, (Object)"Dynamic configuration accessed from outside of an active module configuration scope.");
        return this.configuration;
    }

    public ActiveDescriptor<?> bind(Descriptor descriptor) {
        this.setLoader(descriptor);
        return this.configuration.bind(descriptor);
    }

    public FactoryDescriptors bind(FactoryDescriptors factoryDescriptors) {
        this.setLoader(factoryDescriptors.getFactoryAsAService());
        this.setLoader(factoryDescriptors.getFactoryAsAFactory());
        return this.configuration.bind(factoryDescriptors);
    }

    public <T> ActiveDescriptor<T> addActiveDescriptor(ActiveDescriptor<T> activeDescriptor) throws IllegalArgumentException {
        return this.configuration.addActiveDescriptor(activeDescriptor);
    }

    public <T> ActiveDescriptor<T> addActiveDescriptor(Class<T> rawClass) throws MultiException, IllegalArgumentException {
        return this.configuration.addActiveDescriptor(rawClass);
    }

    public void addUnbindFilter(Filter unbindFilter) throws IllegalArgumentException {
        this.configuration.addUnbindFilter(unbindFilter);
    }

    public void commit() throws MultiException {
        this.configuration.commit();
    }

    public final void install(Module ... modules) {
        for (Module module : modules) {
            module.bind(this);
        }
    }

    private void setLoader(Descriptor descriptor) {
        if (descriptor instanceof DescriptorImpl) {
            final ClassLoader loader = this.getModuleClassloader();
            ((DescriptorImpl)descriptor).setLoader(new HK2Loader(){

                public Class<?> loadClass(String className) throws MultiException {
                    try {
                        return loader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MultiException((Throwable)e);
                    }
                }
            });
        }
    }

    private ClassLoader getModuleClassloader() {
        ClassLoader loader = this.getClass().getClassLoader();
        return loader == null ? ClassLoader.getSystemClassLoader() : loader;
    }
}

