/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.jersey.internal.inject.Module;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;

public class Utilities {
    private static final ServiceLocatorGenerator generator = new ServiceLocatorGeneratorImpl();
    private static final ServiceLocatorFactory factory = ServiceLocatorFactory.getInstance();

    public static ServiceLocator create(String name, ServiceLocator parent, Module ... modules) {
        ServiceLocator locator = factory.create(name, parent, generator);
        ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        for (Module module : modules) {
            Utilities.bindModule(locator, module);
        }
        return locator;
    }

    private static void bindModule(ServiceLocator locator, Module module) {
        DynamicConfigurationService dcs = (DynamicConfigurationService)locator.getService(DynamicConfigurationService.class, new Annotation[0]);
        DynamicConfiguration dc = dcs.createDynamicConfiguration();
        locator.inject((Object)module);
        module.bind(dc);
        dc.commit();
    }

    public static <T> T getOrCreateComponent(ServiceLocator serviceLocator, Class<T> clazz) {
        Object component = serviceLocator.getService(clazz, new Annotation[0]);
        return (T)(component == null ? serviceLocator.createAndInitialize(clazz) : component);
    }

    public static <T> AbstractActiveDescriptor<T> createActiveDescriptor(Class<T> implClass, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, Type ... types) {
        if (qualifiers == null) {
            qualifiers = new HashSet<Annotation>();
        }
        ActiveDescriptorBuilder builder = BuilderHelper.activeLink(implClass).in(scope).named(name);
        for (Annotation annotation : qualifiers) {
            builder.qualifiedBy(annotation);
        }
        for (Type type : types) {
            builder.to(type);
        }
        return builder.build();
    }

    public static <T> FactoryDescriptors createFactoryDescriptor(Class<T> implClass, Class<? extends Annotation> scope, Class<? extends Annotation> factoryScope, String name, Annotation annotation, Type ... types) {
        ActiveDescriptorBuilder sBuilder = BuilderHelper.activeLink(implClass);
        ActiveDescriptorBuilder fBuilder = BuilderHelper.activeLink(implClass);
        if (scope != null) {
            sBuilder.in(scope);
        }
        if (factoryScope != null) {
            fBuilder.in(factoryScope);
        }
        if (name != null) {
            fBuilder.named(name);
            sBuilder.named(name);
        }
        if (annotation != null) {
            fBuilder.qualifiedBy(annotation);
        }
        sBuilder.to(implClass);
        for (Type type : types) {
            sBuilder.to((Type)new ParameterizedTypeImpl(Factory.class, new Type[]{type}));
            fBuilder.to(type);
        }
        return new FactoryDescriptorsImpl((Descriptor)sBuilder.build(), (Descriptor)fBuilder.buildFactory());
    }

    public static <T> FactoryDescriptors createConstantFactoryDescriptor(Factory<?> factory, Class<? extends Annotation> scope, Class<? extends Annotation> factoryScope, String name, Annotation annotation, Type ... types) {
        AbstractActiveDescriptor sDescriptor = BuilderHelper.createConstantDescriptor(factory);
        ActiveDescriptorBuilder fBuilder = BuilderHelper.activeLink(factory.getClass());
        if (scope != null) {
            fBuilder.in(scope);
        }
        if (factoryScope != null) {
            sDescriptor.setScope(factoryScope.getName());
        }
        if (name != null) {
            fBuilder.named(name);
            sDescriptor.setName(name);
        }
        if (annotation != null) {
            fBuilder.qualifiedBy(annotation);
        }
        sDescriptor.addContractType(factory.getClass());
        for (Type type : types) {
            fBuilder.to(type);
            sDescriptor.addContractType((Type)new ParameterizedTypeImpl(Factory.class, new Type[]{type}));
        }
        return new FactoryDescriptorsImpl((Descriptor)sDescriptor, (Descriptor)fBuilder.buildFactory());
    }

    public static class FactoryDescriptorsImpl
    implements FactoryDescriptors {
        private final Descriptor serviceDescriptor;
        private final Descriptor factoryDescriptor;

        public FactoryDescriptorsImpl(Descriptor serviceDescriptor, Descriptor factoryDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            this.factoryDescriptor = factoryDescriptor;
        }

        public Descriptor getFactoryAsAService() {
            return this.serviceDescriptor;
        }

        public Descriptor getFactoryAsAFactory() {
            return this.factoryDescriptor;
        }

        public String toString() {
            return "FactoryDescriptorsImpl(\n" + this.serviceDescriptor + ",\n" + this.factoryDescriptor + ",\n\t" + System.identityHashCode(this) + ")";
        }
    }
}

