/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;

public class ReflectionHelper {
    private static final Logger LOGGER = Logger.getLogger(ReflectionHelper.class.getName());

    public static Class<?> getDeclaringClass(AccessibleObject ao) {
        if (ao instanceof Method) {
            return ((Method)ao).getDeclaringClass();
        }
        if (ao instanceof Field) {
            return ((Field)ao).getDeclaringClass();
        }
        if (ao instanceof Constructor) {
            return ((Constructor)ao).getDeclaringClass();
        }
        throw new IllegalArgumentException("Unsupported accessible object type: " + ao.getClass().getName());
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode()));
        return sb.toString();
    }

    public static String methodInstanceToString(Object o, Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(o.getClass().getName()).append('@').append(Integer.toHexString(o.hashCode())).append('.').append(m.getName()).append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append(ReflectionHelper.getTypeName(params[i]));
            if (i >= params.length - 1) continue;
            sb.append(",");
        }
        sb.append(')');
        return sb.toString();
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static <T> Class<T> classForName(String name) {
        return ReflectionHelper.classForName(name, ReflectionHelper.getContextClassLoader());
    }

    public static <T> Class<T> classForName(String name, ClassLoader cl) {
        block6: {
            if (cl != null) {
                try {
                    return Class.forName(name, false, cl);
                }
                catch (ClassNotFoundException ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.log(Level.FINE, "Unable to load class " + name + " using the supplied classloader " + cl.getClass().getName() + ".", ex);
                }
            }
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to load class " + name + " using the current classloader.", ex);
            }
            return null;
        }
    }

    public static <T> Class<T> classForNameWithException(String name) throws ClassNotFoundException {
        return ReflectionHelper.classForNameWithException(name, ReflectionHelper.getContextClassLoader());
    }

    public static <T> Class<T> classForNameWithException(String name, ClassLoader cl) throws ClassNotFoundException {
        if (cl != null) {
            try {
                return Class.forName(name, false, cl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Class.forName(name);
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    public static void setAccessibleMethod(final Method m) {
        if (Modifier.isPublic(m.getModifiers())) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m;
            }
        });
    }

    public static List<Class<?>> getGenericTypeArgumentClasses(Type type) throws IllegalArgumentException {
        Type[] types = ReflectionHelper.getTypeArgumentOfParameterizedType(type);
        if (types == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Collections2.transform(Arrays.asList(types), (Function)new Function<Type, Class<?>>(){

            public Class<?> apply(Type input) {
                return ReflectionHelper.getClassOfType(input);
            }
        }));
    }

    public static List<ClassTypePair> getTypeArgumentAndClass(Type type) throws IllegalArgumentException {
        Type[] types = ReflectionHelper.getTypeArgumentOfParameterizedType(type);
        if (types == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Collections2.transform(Arrays.asList(types), (Function)new Function<Type, ClassTypePair>(){

            public ClassTypePair apply(Type input) {
                return ClassTypePair.of(ReflectionHelper.getClassOfType(input), input);
            }
        }));
    }

    private static Type[] getTypeArgumentOfParameterizedType(Type parameterizedType) {
        if (!(parameterizedType instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)parameterizedType).getActualTypeArguments();
    }

    private static Class<?> getClassOfType(Type type) {
        ParameterizedType subType;
        Type t;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type t2 = arrayType.getGenericComponentType();
            if (t2 instanceof Class) {
                return ReflectionHelper.getArrayClass((Class)t2);
            }
        } else if (type instanceof ParameterizedType && (t = (subType = (ParameterizedType)type).getRawType()) instanceof Class) {
            return (Class)t;
        }
        throw new IllegalArgumentException(LocalizationMessages.TYPE_TO_CLASS_CONVERSION_NOT_SUPPORTED(type));
    }

    public static Class<?> getArrayClass(Class<?> c) {
        try {
            Object o = Array.newInstance(c, 0);
            return o.getClass();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method getValueOfStringMethod(Class<?> c) {
        try {
            Method m = c.getDeclaredMethod("valueOf", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Method getFromStringStringMethod(Class<?> c) {
        try {
            Method m = c.getDeclaredMethod("fromString", String.class);
            if (!Modifier.isStatic(m.getModifiers()) && m.getReturnType() == c) {
                return null;
            }
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getStringConstructor(Class<?> c) {
        try {
            return c.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Collection<Class<? extends Annotation>> getAnnotationTypes(AnnotatedElement annotatedElement, Class<? extends Annotation> metaAnnotation) {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        for (Annotation a : annotatedElement.getAnnotations()) {
            Class<? extends Annotation> aType = a.annotationType();
            if (metaAnnotation != null && aType.getAnnotation(metaAnnotation) == null) continue;
            result.add(aType);
        }
        return result;
    }

    public static Class[] getParameterizedClassArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Class[] cas = new Class[as.length];
            for (int i = 0; i < as.length; ++i) {
                Type a = as[i];
                if (a instanceof Class) {
                    cas[i] = (Class)a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    pt = (ParameterizedType)a;
                    cas[i] = (Class)pt.getRawType();
                    continue;
                }
                if (!(a instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a);
                cas[i] = ctp != null ? ctp.rawClass() : Object.class;
            }
            return cas;
        }
        return null;
    }

    public static Type[] getParameterizedTypeArguments(DeclaringClassInterfacePair p) {
        if (p.genericInterface instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)p.genericInterface;
            Type[] as = pt.getActualTypeArguments();
            Type[] ras = new Type[as.length];
            for (int i = 0; i < as.length; ++i) {
                Type a = as[i];
                if (a instanceof Class) {
                    ras[i] = a;
                    continue;
                }
                if (a instanceof ParameterizedType) {
                    ras[i] = a;
                    continue;
                }
                if (!(a instanceof TypeVariable)) continue;
                ClassTypePair ctp = ReflectionHelper.resolveTypeVariable(p.concreteClass, p.declaringClass, (TypeVariable)a);
                ras[i] = ctp.type();
            }
            return ras;
        }
        return null;
    }

    public static DeclaringClassInterfacePair getClass(Class<?> concrete, Class<?> iface) {
        return ReflectionHelper.getClass(concrete, iface, concrete);
    }

    private static DeclaringClassInterfacePair getClass(Class<?> concrete, Class<?> iface, Class<?> c) {
        Type[] gis = c.getGenericInterfaces();
        DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c, gis);
        if (p != null) {
            return p;
        }
        if ((c = c.getSuperclass()) == null || c == Object.class) {
            return null;
        }
        return ReflectionHelper.getClass(concrete, iface, c);
    }

    private static DeclaringClassInterfacePair getType(Class<?> concrete, Class<?> iface, Class<?> c, Type[] ts) {
        for (Type t : ts) {
            DeclaringClassInterfacePair p = ReflectionHelper.getType(concrete, iface, c, t);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    private static DeclaringClassInterfacePair getType(Class<?> concrete, Class<?> iface, Class<?> c, Type t) {
        if (t instanceof Class) {
            if (t == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            if (pt.getRawType() == iface) {
                return new DeclaringClassInterfacePair(concrete, c, t);
            }
            return ReflectionHelper.getClass(concrete, iface, (Class)pt.getRawType());
        }
        return null;
    }

    public static ClassTypePair resolveGenericType(Class concreteClass, Class declaringClass, Class rawResolvedType, Type genericResolvedType) {
        if (genericResolvedType instanceof TypeVariable) {
            ClassTypePair ct = ReflectionHelper.resolveTypeVariable(concreteClass, declaringClass, (TypeVariable)genericResolvedType);
            if (ct != null) {
                return ct;
            }
        } else if (genericResolvedType instanceof ParameterizedType) {
            final ParameterizedType pt = (ParameterizedType)genericResolvedType;
            final Type[] ptts = pt.getActualTypeArguments();
            boolean modified = false;
            for (int i = 0; i < ptts.length; ++i) {
                ClassTypePair ct = ReflectionHelper.resolveGenericType(concreteClass, declaringClass, (Class)pt.getRawType(), ptts[i]);
                if (ct.type() == ptts[i]) continue;
                ptts[i] = ct.type();
                modified = true;
            }
            if (modified) {
                ParameterizedType rpt = new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return (Type[])ptts.clone();
                    }

                    @Override
                    public Type getRawType() {
                        return pt.getRawType();
                    }

                    @Override
                    public Type getOwnerType() {
                        return pt.getOwnerType();
                    }
                };
                return ClassTypePair.of((Class)pt.getRawType(), rpt);
            }
        } else if (genericResolvedType instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)genericResolvedType;
            ClassTypePair ct = ReflectionHelper.resolveGenericType(concreteClass, declaringClass, null, gat.getGenericComponentType());
            if (gat.getGenericComponentType() != ct.type()) {
                try {
                    Class<?> ac = ReflectionHelper.getArrayClass(ct.rawClass());
                    return ClassTypePair.of(ac);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return ClassTypePair.of(rawResolvedType, genericResolvedType);
    }

    public static ClassTypePair resolveTypeVariable(Class<?> c, Class<?> dc, TypeVariable tv) {
        return ReflectionHelper.resolveTypeVariable(c, dc, tv, new HashMap<TypeVariable, Type>());
    }

    private static ClassTypePair resolveTypeVariable(Class<?> c, Class<?> dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] gis;
        for (Type gi : gis = c.getGenericInterfaces()) {
            ParameterizedType pt;
            ClassTypePair ctp;
            if (!(gi instanceof ParameterizedType) || (ctp = ReflectionHelper.resolveTypeVariable(pt = (ParameterizedType)gi, (Class)pt.getRawType(), dc, tv, map)) == null) continue;
            return ctp;
        }
        Type gsc = c.getGenericSuperclass();
        if (gsc instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gsc;
            return ReflectionHelper.resolveTypeVariable(pt, c.getSuperclass(), dc, tv, map);
        }
        if (gsc instanceof Class) {
            return ReflectionHelper.resolveTypeVariable(c.getSuperclass(), dc, tv, map);
        }
        return null;
    }

    private static ClassTypePair resolveTypeVariable(ParameterizedType pt, Class<?> c, Class<?> dc, TypeVariable tv, Map<TypeVariable, Type> map) {
        Type[] typeArguments = pt.getActualTypeArguments();
        TypeVariable<Class<?>>[] typeParameters = c.getTypeParameters();
        HashMap<TypeVariable, Type> submap = new HashMap<TypeVariable, Type>();
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] instanceof TypeVariable) {
                Type t = map.get((TypeVariable)typeArguments[i]);
                submap.put(typeParameters[i], t);
                continue;
            }
            submap.put(typeParameters[i], typeArguments[i]);
        }
        if (c == dc) {
            Type t = (Type)submap.get(tv);
            if (t instanceof Class) {
                return ClassTypePair.of((Class)t);
            }
            if (t instanceof GenericArrayType) {
                GenericArrayType gat = (GenericArrayType)t;
                if ((t = gat.getGenericComponentType()) instanceof Class) {
                    c = (Class)t;
                    try {
                        return ClassTypePair.of(ReflectionHelper.getArrayClass(c));
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                if (t instanceof ParameterizedType) {
                    Type rt = ((ParameterizedType)t).getRawType();
                    if (!(rt instanceof Class)) {
                        return null;
                    }
                    c = (Class)rt;
                    try {
                        return ClassTypePair.of(ReflectionHelper.getArrayClass(c), gat);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
            if (t instanceof ParameterizedType) {
                pt = (ParameterizedType)t;
                if (pt.getRawType() instanceof Class) {
                    return ClassTypePair.of((Class)pt.getRawType(), pt);
                }
                return null;
            }
            return null;
        }
        return ReflectionHelper.resolveTypeVariable(c, dc, tv, submap);
    }

    public static Method findMethodOnClass(Class<?> c, Method m) {
        try {
            return c.getMethod(m.getName(), m.getParameterTypes());
        }
        catch (NoSuchMethodException ex) {
            for (Method _m : c.getMethods()) {
                if (!_m.getName().equals(m.getName()) || _m.getParameterTypes().length != m.getParameterTypes().length || !ReflectionHelper.compareParameterTypes(m.getGenericParameterTypes(), _m.getGenericParameterTypes())) continue;
                return _m;
            }
            return null;
        }
    }

    private static boolean compareParameterTypes(Type[] ts, Type[] _ts) {
        for (int i = 0; i < ts.length; ++i) {
            if (ts[i].equals(_ts[i]) || _ts[i] instanceof TypeVariable) continue;
            return false;
        }
        return true;
    }

    private ReflectionHelper() {
    }

    public static class DeclaringClassInterfacePair {
        public final Class<?> concreteClass;
        public final Class<?> declaringClass;
        public final Type genericInterface;

        private DeclaringClassInterfacePair(Class<?> concreteClass, Class<?> declaringClass, Type genericInteface) {
            this.concreteClass = concreteClass;
            this.declaringClass = declaringClass;
            this.genericInterface = genericInteface;
        }
    }
}

