/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.AbstractModule;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.KeyComparator;
import org.glassfish.jersey.internal.util.KeyComparatorHashMap;
import org.glassfish.jersey.internal.util.KeyComparatorLinkedHashMap;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;
import org.glassfish.jersey.message.internal.WriterInterceptorExecutor;
import org.glassfish.jersey.process.internal.RequestScoped;

public class MessageBodyFactory
implements MessageBodyWorkers {
    public static final KeyComparator<MediaType> MEDIA_TYPE_COMPARATOR = new KeyComparator<MediaType>(){
        private static final long serialVersionUID = 2727819828630827763L;

        @Override
        public boolean equals(MediaType x, MediaType y) {
            return x.getType().equalsIgnoreCase(y.getType()) && x.getSubtype().equalsIgnoreCase(y.getSubtype());
        }

        @Override
        public int hash(MediaType k) {
            return k.getType().toLowerCase().hashCode() + k.getSubtype().toLowerCase().hashCode();
        }

        @Override
        public int compare(MediaType o1, MediaType o2) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private final ServiceLocator services;
    private Map<MediaType, List<MessageBodyReader>> readerProviders;
    private Map<MediaType, List<MessageBodyWriter>> writerProviders;
    private List<MessageBodyReaderPair> readerListProviders;
    private List<MessageBodyWriterPair> writerListProviders;
    private Map<MediaType, List<MessageBodyReader>> customReaderProviders;
    private Map<MediaType, List<MessageBodyWriter>> customWriterProviders;
    private List<MessageBodyReaderPair> customReaderListProviders;
    private List<MessageBodyWriterPair> customWriterListProviders;
    private List<ReaderInterceptor> readerInterceptors;
    private List<WriterInterceptor> writerInterceptors;

    @Override
    public List<ReaderInterceptor> getReaderInterceptors() {
        return this.readerInterceptors;
    }

    @Override
    public List<WriterInterceptor> getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public MessageBodyFactory(ServiceLocator services) {
        this.services = services;
        this.initReaders();
        this.initWriters();
        this.initInterceptors();
    }

    private void initInterceptors() {
        this.readerInterceptors = this.services.getAllServices(ReaderInterceptor.class, new Annotation[0]);
        this.writerInterceptors = this.services.getAllServices(WriterInterceptor.class, new Annotation[0]);
    }

    private void initReaders() {
        this.customReaderProviders = new KeyComparatorHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        this.customReaderListProviders = new ArrayList<MessageBodyReaderPair>();
        this.readerProviders = new KeyComparatorHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        this.readerListProviders = new ArrayList<MessageBodyReaderPair>();
        this.initReaders(this.customReaderProviders, this.customReaderListProviders, Providers.getCustomProviders(this.services, MessageBodyReader.class));
        this.initReaders(this.readerProviders, this.readerListProviders, Providers.getProviders(this.services, MessageBodyReader.class));
    }

    private void initReaders(Map<MediaType, List<MessageBodyReader>> mediaToProvidersMap, List<MessageBodyReaderPair> listProviders, Set<MessageBodyReader> providersSet) {
        for (MessageBodyReader provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Consumes.class));
            for (MediaType type : values) {
                this.registerProviderForMediaType(mediaToProvidersMap, provider, type);
            }
            listProviders.add(new MessageBodyReaderPair(provider, values));
        }
        final DeclarationDistanceComparator<MessageBodyReader> dc = new DeclarationDistanceComparator<MessageBodyReader>(MessageBodyReader.class);
        for (Map.Entry<MediaType, List<MessageBodyReader>> e : mediaToProvidersMap.entrySet()) {
            Collections.sort(e.getValue(), dc);
        }
        Collections.sort(listProviders, new Comparator<MessageBodyReaderPair>(){

            @Override
            public int compare(MessageBodyReaderPair p1, MessageBodyReaderPair p2) {
                return dc.compare(p1.mbr, p2.mbr);
            }
        });
    }

    private void initWriters() {
        this.customWriterProviders = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.customWriterListProviders = new ArrayList<MessageBodyWriterPair>();
        this.writerProviders = new KeyComparatorHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        this.writerListProviders = new ArrayList<MessageBodyWriterPair>();
        this.initWriters(this.customWriterProviders, this.customWriterListProviders, Providers.getCustomProviders(this.services, MessageBodyWriter.class));
        this.initWriters(this.writerProviders, this.writerListProviders, Providers.getProviders(this.services, MessageBodyWriter.class));
    }

    private void initWriters(Map<MediaType, List<MessageBodyWriter>> mediaToProvidersMap, List<MessageBodyWriterPair> listProviders, Set<MessageBodyWriter> providersSet) {
        for (MessageBodyWriter provider : providersSet) {
            List<MediaType> values = MediaTypes.createFrom(provider.getClass().getAnnotation(Produces.class));
            for (MediaType type : values) {
                this.registerProviderForMediaType(mediaToProvidersMap, provider, type);
            }
            listProviders.add(new MessageBodyWriterPair(provider, values));
        }
        final DeclarationDistanceComparator<MessageBodyWriter> dc = new DeclarationDistanceComparator<MessageBodyWriter>(MessageBodyWriter.class);
        for (Map.Entry<MediaType, List<MessageBodyWriter>> e : mediaToProvidersMap.entrySet()) {
            Collections.sort(e.getValue(), dc);
        }
        Collections.sort(listProviders, new Comparator<MessageBodyWriterPair>(){

            @Override
            public int compare(MessageBodyWriterPair p1, MessageBodyWriterPair p2) {
                return dc.compare(p1.mbw, p2.mbw);
            }
        });
    }

    private <T> void registerProviderForMediaType(Map<MediaType, List<T>> mediaToProviderMap, T provider, MediaType mediaType) {
        if (!mediaToProviderMap.containsKey(mediaType)) {
            mediaToProviderMap.put(mediaType, new ArrayList());
        }
        List<T> providers = mediaToProviderMap.get(mediaType);
        providers.add(provider);
    }

    @Override
    public Map<MediaType, List<MessageBodyReader>> getReaders(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyReader>>(MEDIA_TYPE_COMPARATOR);
        if (!this.customReaderProviders.isEmpty()) {
            this.getCompatibleProvidersMap(mediaType, this.customReaderProviders, subSet);
        }
        this.getCompatibleProvidersMap(mediaType, this.readerProviders, subSet);
        return subSet;
    }

    @Override
    public Map<MediaType, List<MessageBodyWriter>> getWriters(MediaType mediaType) {
        KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>> subSet = new KeyComparatorLinkedHashMap<MediaType, List<MessageBodyWriter>>(MEDIA_TYPE_COMPARATOR);
        if (!this.customWriterProviders.isEmpty()) {
            this.getCompatibleProvidersMap(mediaType, this.customWriterProviders, subSet);
        }
        this.getCompatibleProvidersMap(mediaType, this.writerProviders, subSet);
        return subSet;
    }

    @Override
    public String readersToString(Map<MediaType, List<MessageBodyReader>> readers) {
        return this.toString(readers);
    }

    @Override
    public String writersToString(Map<MediaType, List<MessageBodyWriter>> writers) {
        return this.toString(writers);
    }

    private <T> String toString(Map<MediaType, List<T>> set) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Map.Entry<MediaType, List<T>> e : set.entrySet()) {
            pw.append(e.getKey().toString()).println(" ->");
            for (T t : e.getValue()) {
                pw.append("  ").println(t.getClass().getName());
            }
        }
        pw.flush();
        return sw.toString();
    }

    @Override
    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyReader<T> reader;
        if (!this.customReaderProviders.isEmpty() && (reader = this._getMessageBodyReader(c, t, as, mediaType, this.customReaderProviders)) != null) {
            return reader;
        }
        reader = this._getMessageBodyReader(c, t, as, mediaType, this.readerProviders);
        return reader;
    }

    @Override
    public <T> List<MediaType> getMessageBodyReaderMediaTypes(Class<T> type, Type genericType, Annotation[] annotations) {
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (MessageBodyReaderPair mbrp : this.customReaderListProviders) {
            for (MediaType mt : mbrp.types) {
                if (!mbrp.mbr.isReadable(type, genericType, annotations, mt)) continue;
                mtl.add(mt);
            }
        }
        for (MessageBodyReaderPair mbrp : this.readerListProviders) {
            for (MediaType mt : mbrp.types) {
                if (!mbrp.mbr.isReadable(type, genericType, annotations, mt)) continue;
                mtl.addAll(mbrp.types);
            }
        }
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, Map<MediaType, List<MessageBodyReader>> providers) {
        MessageBodyReader<T> p = null;
        if (mediaType != null && (p = this._getMessageBodyReader(c, t, as, mediaType, mediaType, providers)) == null) {
            p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType), providers);
        }
        if (p == null) {
            p = this._getMessageBodyReader(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE, providers);
        }
        return p;
    }

    private <T> MessageBodyReader<T> _getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup, Map<MediaType, List<MessageBodyReader>> providers) {
        List<MessageBodyReader> readers = providers.get(lookup);
        if (readers == null) {
            return null;
        }
        for (MessageBodyReader p : readers) {
            if (!p.isReadable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    @Override
    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType) {
        MessageBodyWriter<T> p;
        if (!this.customWriterProviders.isEmpty() && (p = this._getMessageBodyWriter(c, t, as, mediaType, this.customWriterProviders)) != null) {
            return p;
        }
        p = this._getMessageBodyWriter(c, t, as, mediaType, this.writerProviders);
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, Map<MediaType, List<MessageBodyWriter>> providers) {
        MessageBodyWriter<T> p = null;
        if (mediaType != null && (p = this._getMessageBodyWriter(c, t, as, mediaType, mediaType, providers)) == null) {
            p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.getTypeWildCart(mediaType), providers);
        }
        if (p == null) {
            p = this._getMessageBodyWriter(c, t, as, mediaType, MediaTypes.GENERAL_MEDIA_TYPE, providers);
        }
        return p;
    }

    private <T> MessageBodyWriter<T> _getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType mediaType, MediaType lookup, Map<MediaType, List<MessageBodyWriter>> providers) {
        List<MessageBodyWriter> writers = providers.get(lookup);
        if (writers == null) {
            return null;
        }
        for (MessageBodyWriter p : writers) {
            if (!p.isWriteable(c, t, as, mediaType)) continue;
            return p;
        }
        return null;
    }

    private <T> void getCompatibleProvidersMap(MediaType mediaType, Map<MediaType, List<T>> set, Map<MediaType, List<T>> subSet) {
        if (mediaType.isWildcardType()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
        } else if (mediaType.isWildcardSubtype()) {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        } else {
            this.getCompatibleProvidersList(mediaType, set, subSet);
            this.getCompatibleProvidersList(MediaTypes.getTypeWildCart(mediaType), set, subSet);
            this.getCompatibleProvidersList(MediaTypes.GENERAL_MEDIA_TYPE, set, subSet);
        }
    }

    private <T> void getCompatibleProvidersList(MediaType mediaType, Map<MediaType, List<T>> set, Map<MediaType, List<T>> subSet) {
        List<T> readers = set.get(mediaType);
        if (readers != null) {
            subSet.put(mediaType, Collections.unmodifiableList(readers));
        }
    }

    @Override
    public <T> List<MediaType> getMessageBodyWriterMediaTypes(Class<T> c, Type t, Annotation[] as) {
        ArrayList<MediaType> mtl = new ArrayList<MediaType>();
        for (MessageBodyWriterPair mbwp : this.customWriterListProviders) {
            for (MediaType mt : mbwp.types) {
                if (!mbwp.mbw.isWriteable(c, t, as, mt)) continue;
                mtl.add(mt);
            }
        }
        for (MessageBodyWriterPair mbwp : this.writerListProviders) {
            for (MediaType mt : mbwp.types) {
                if (!mbwp.mbw.isWriteable(c, t, as, mt)) continue;
                mtl.addAll(mbwp.types);
            }
        }
        Collections.sort(mtl, MediaTypes.MEDIA_TYPE_COMPARATOR);
        return mtl;
    }

    @Override
    public <T> MediaType getMessageBodyWriterMediaType(Class<T> c, Type t, Annotation[] as, List<MediaType> acceptableMediaTypes) {
        for (MediaType acceptable : acceptableMediaTypes) {
            for (MessageBodyWriterPair mbwp : this.customWriterListProviders) {
                for (MediaType mt : mbwp.types) {
                    if (!mt.isCompatible(acceptable) || !mbwp.mbw.isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
            for (MessageBodyWriterPair mbwp : this.writerListProviders) {
                for (MediaType mt : mbwp.types) {
                    if (!mt.isCompatible(acceptable) || !mbwp.mbw.isWriteable(c, t, as, acceptable)) continue;
                    return MediaTypes.mostSpecific(mt, acceptable);
                }
            }
        }
        return null;
    }

    @Override
    public <T> Object readFrom(Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, PropertiesDelegate propertiesDelegate, InputStream entityStream, boolean intercept) throws WebApplicationException, IOException {
        ReaderInterceptorExecutor executor = new ReaderInterceptorExecutor(rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, intercept);
        return executor.proceed();
    }

    @Override
    public <T> void writeTo(Object t, Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept) throws IOException, WebApplicationException {
        this.writeTo(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, sizeCallback, intercept, true);
    }

    @Override
    public <T> void writeTo(Object t, Class<T> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, PropertiesDelegate propertiesDelegate, OutputStream entityStream, MessageBodyWorkers.MessageBodySizeCallback sizeCallback, boolean intercept, boolean writeEntity) throws IOException, WebApplicationException {
        WriterInterceptorExecutor executor = new WriterInterceptorExecutor(t, rawType, type, annotations, mediaType, httpHeaders, propertiesDelegate, entityStream, this, sizeCallback, intercept, writeEntity);
        executor.proceed();
    }

    private static class DeclarationDistanceComparator<T>
    implements Comparator<T> {
        private final Class<T> declared;
        private final Map<Class, Integer> distanceMap = new HashMap<Class, Integer>();

        DeclarationDistanceComparator(Class<T> declared) {
            this.declared = declared;
        }

        @Override
        public int compare(T o1, T o2) {
            int d1 = this.getDistance(o1);
            int d2 = this.getDistance(o2);
            return d2 - d1;
        }

        private int getDistance(T t) {
            Integer distance = this.distanceMap.get(t.getClass());
            if (distance != null) {
                return distance;
            }
            distance = 0;
            for (Class a = (as = ReflectionHelper.getParameterizedClassArguments(p = ReflectionHelper.getClass(t.getClass(), this.declared))) != null ? as[0] : null; a != null && a != Object.class; a = a.getSuperclass()) {
                Integer n = distance;
                Integer n2 = distance = Integer.valueOf(distance + 1);
            }
            this.distanceMap.put(t.getClass(), distance);
            return distance;
        }
    }

    private static class MessageBodyReaderPair {
        final MessageBodyReader<?> mbr;
        final List<MediaType> types;

        MessageBodyReaderPair(MessageBodyReader<?> mbr, List<MediaType> types) {
            this.mbr = mbr;
            this.types = types;
        }
    }

    private static class MessageBodyWriterPair {
        final MessageBodyWriter<?> mbw;
        final List<MediaType> types;

        MessageBodyWriterPair(MessageBodyWriter<?> mbw, List<MediaType> types) {
            this.mbw = mbw;
            this.types = types;
        }
    }

    public static class Module
    extends AbstractModule {
        private final Class<? extends Annotation> refScope;

        public Module(Class<? extends Annotation> refScope) {
            this.refScope = refScope;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected void configure() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
             *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ExpressionStatement.rewriteExpressions(ExpressionStatement.java:40)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static class InjectionFactory
        extends ReferencingFactory<MessageBodyWorkers> {
            @Inject
            public InjectionFactory(Provider<Ref<MessageBodyWorkers>> referenceFactory) {
                super(referenceFactory);
            }

            @Override
            @RequestScoped
            public MessageBodyWorkers provide() {
                return (MessageBodyWorkers)super.provide();
            }
        }
    }
}

