/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.util.LinkedList;
import java.util.regex.Pattern;

public final class Tokenizer {
    public static final String COMMON_DELIMITERS = " ,;\n";

    private Tokenizer() {
    }

    public static String[] tokenize(String[] entries) {
        return Tokenizer.tokenize(entries, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String[] entries, String delimiters) {
        LinkedList<String> es = new LinkedList<String>();
        for (String element : entries) {
            if (element == null || (element = element.trim()).length() == 0) continue;
            for (String subElement : Tokenizer.tokenize(element, delimiters)) {
                if (subElement == null || subElement.length() == 0) continue;
                es.add(subElement);
            }
        }
        return es.toArray(new String[es.size()]);
    }

    public static String[] tokenize(String entry) {
        return Tokenizer.tokenize(entry, COMMON_DELIMITERS);
    }

    public static String[] tokenize(String entry, String delimiters) {
        String regex = "[";
        for (char c : delimiters.toCharArray()) {
            regex = regex + Pattern.quote(String.valueOf(c));
        }
        regex = regex + "]";
        String[] es = entry.split(regex);
        for (int i = 0; i < es.length; ++i) {
            es[i] = es[i].trim();
        }
        return es;
    }
}

