/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.transform.Source;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.AcceptableToken;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.HeadersFactory;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.message.internal.MatchingEntityTag;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class InboundMessageContext {
    private static final Logger LOGGER = Logger.getLogger(InboundMessageContext.class.getName());
    private static final InputStream EMPTY = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final MultivaluedMap<String, String> headers = HeadersFactory.createInbound();
    private final ContentStream contentStream = new ContentStream(EMPTY);
    private MessageBodyWorkers workers;

    public InboundMessageContext header(String name, Object value) {
        this.getHeaders().add((Object)name, (Object)HeadersFactory.asString(value, RuntimeDelegate.getInstance()));
        return this;
    }

    public InboundMessageContext headers(String name, Object ... values) {
        this.getHeaders().addAll((Object)name, HeadersFactory.asStringList(Arrays.asList(values), RuntimeDelegate.getInstance()));
        return this;
    }

    public InboundMessageContext headers(String name, Iterable<?> values) {
        this.getHeaders().addAll((Object)name, InboundMessageContext.iterableToList(values));
        return this;
    }

    public InboundMessageContext headers(MultivaluedMap<String, String> headers) {
        this.getHeaders().putAll(headers);
        return this;
    }

    public InboundMessageContext headers(Map<String, List<String>> headers) {
        this.getHeaders().putAll(headers);
        return this;
    }

    public InboundMessageContext remove(String name) {
        this.getHeaders().remove((Object)name);
        return this;
    }

    public InboundMessageContext replaceHeaders(MultivaluedMap<String, String> headers) {
        this.headers.clear();
        this.headers.putAll(headers);
        return this;
    }

    private static List<String> iterableToList(Iterable<?> values) {
        LinkedList<String> linkedList = new LinkedList<String>();
        RuntimeDelegate rd = RuntimeDelegate.getInstance();
        for (Object element : values) {
            linkedList.add(HeadersFactory.asString(element, rd));
        }
        return linkedList;
    }

    public String getHeaderString(String name) {
        List values = (List)this.headers.get((Object)name);
        if (values == null) {
            return null;
        }
        if (values.isEmpty()) {
            return "";
        }
        Iterator valuesIterator = values.iterator();
        StringBuilder buffer = new StringBuilder((String)valuesIterator.next());
        while (valuesIterator.hasNext()) {
            buffer.append(',').append((String)valuesIterator.next());
        }
        return buffer.toString();
    }

    private <T> T singleHeader(String name, Function<String, T> converter, boolean convertNull) {
        List values = (List)this.headers.get((Object)name);
        if (values == null || values.isEmpty()) {
            return (T)(convertNull ? converter.apply(null) : null);
        }
        if (values.size() > 1) {
            throw new HeaderValueException(LocalizationMessages.TOO_MANY_HEADER_VALUES(name, values.toString()));
        }
        Object value = values.get(0);
        if (value == null) {
            return (T)(convertNull ? converter.apply(null) : null);
        }
        try {
            return (T)converter.apply((Object)HeadersFactory.asString(value, null));
        }
        catch (ProcessingException ex) {
            throw InboundMessageContext.exception(name, value, ex);
        }
    }

    private static HeaderValueException exception(String headerName, Object headerValue, Exception e) {
        return new HeaderValueException(LocalizationMessages.UNABLE_TO_PARSE_HEADER_VALUE(headerName, headerValue), e);
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public Date getDate() {
        return this.singleHeader("Date", new Function<String, Date>(){

            public Date apply(String input) {
                try {
                    return HttpHeaderReader.readDate(input);
                }
                catch (ParseException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, false);
    }

    public Set<MatchingEntityTag> getIfMatch() {
        String ifMatch = this.getHeaderString("If-Match");
        if (ifMatch == null || ifMatch.length() == 0) {
            return null;
        }
        try {
            return HttpHeaderReader.readMatchingEntityTag(ifMatch);
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("If-Match", ifMatch, e);
        }
    }

    public Set<MatchingEntityTag> getIfNoneMatch() {
        String ifNoneMatch = this.getHeaderString("If-None-Match");
        if (ifNoneMatch == null || ifNoneMatch.length() == 0) {
            return null;
        }
        try {
            return HttpHeaderReader.readMatchingEntityTag(ifNoneMatch);
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("If-None-Match", ifNoneMatch, e);
        }
    }

    public Locale getLanguage() {
        return this.singleHeader("Content-Language", new Function<String, Locale>(){

            public Locale apply(String input) {
                try {
                    return new LanguageTag(input).getAsLocale();
                }
                catch (ParseException e) {
                    throw new ProcessingException(e);
                }
            }
        }, false);
    }

    public int getLength() {
        return this.singleHeader("Content-Length", new Function<String, Integer>(){

            public Integer apply(String input) {
                try {
                    return input != null && input.length() > 0 ? Integer.parseInt(input) : -1;
                }
                catch (NumberFormatException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, true);
    }

    public MediaType getMediaType() {
        return this.singleHeader("Content-Type", new Function<String, MediaType>(){

            public MediaType apply(String input) {
                return MediaType.valueOf((String)input);
            }
        }, false);
    }

    public List<AcceptableMediaType> getQualifiedAcceptableMediaTypes() {
        String value = this.getHeaderString("Accept");
        if (value == null || value.length() == 0) {
            return Collections.unmodifiableList(MediaTypes.GENERAL_ACCEPT_MEDIA_TYPE_LIST);
        }
        try {
            return Collections.unmodifiableList(HttpHeaderReader.readAcceptMediaType(value));
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("Accept", value, e);
        }
    }

    public List<AcceptableLanguageTag> getQualifiedAcceptableLanguages() {
        String value = this.getHeaderString("Accept-Language");
        if (value == null || value.length() == 0) {
            return Collections.singletonList(new AcceptableLanguageTag("*", null));
        }
        try {
            return Collections.unmodifiableList(HttpHeaderReader.readAcceptLanguage(value));
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("Accept-Language", value, e);
        }
    }

    public List<AcceptableToken> getQualifiedAcceptCharset() {
        String acceptCharset = this.getHeaderString("Accept-Charset");
        try {
            if (acceptCharset == null || acceptCharset.length() == 0) {
                return Collections.singletonList(new AcceptableToken("*"));
            }
            return HttpHeaderReader.readAcceptToken(acceptCharset);
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("Accept-Charset", acceptCharset, e);
        }
    }

    public List<AcceptableToken> getQualifiedAcceptEncoding() {
        String acceptEncoding = this.getHeaderString("Accept-Encoding");
        try {
            if (acceptEncoding == null || acceptEncoding.length() == 0) {
                return Collections.singletonList(new AcceptableToken("*"));
            }
            return HttpHeaderReader.readAcceptToken(acceptEncoding);
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("Accept-Encoding", acceptEncoding, e);
        }
    }

    public Map<String, Cookie> getRequestCookies() {
        List cookies = (List)this.headers.get((Object)"Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> result = new HashMap<String, Cookie>();
        for (String cookie : cookies) {
            if (cookie == null) continue;
            result.putAll(HttpHeaderReader.readCookies(cookie));
        }
        return result;
    }

    public Set<String> getAllowedMethods() {
        String allowed = this.getHeaderString("Allow");
        if (allowed == null || allowed.length() == 0) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<String>(HttpHeaderReader.readStringList(allowed));
        }
        catch (ParseException e) {
            throw InboundMessageContext.exception("Allow", allowed, e);
        }
    }

    public Map<String, NewCookie> getResponseCookies() {
        List cookies = (List)this.headers.get((Object)"Set-Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result = new HashMap<String, NewCookie>();
        for (String cookie : cookies) {
            if (cookie == null) continue;
            NewCookie newCookie = HttpHeaderReader.readNewCookie(cookie);
            result.put(newCookie.getName(), newCookie);
        }
        return result;
    }

    public EntityTag getEntityTag() {
        return this.singleHeader("ETag", new Function<String, EntityTag>(){

            public EntityTag apply(String value) {
                return EntityTag.valueOf((String)value);
            }
        }, false);
    }

    public Date getLastModified() {
        return this.singleHeader("Last-Modified", new Function<String, Date>(){

            public Date apply(String input) {
                try {
                    return HttpHeaderReader.readDate(input);
                }
                catch (ParseException e) {
                    throw new ProcessingException(e);
                }
            }
        }, false);
    }

    public URI getLocation() {
        return this.singleHeader("Location", new Function<String, URI>(){

            public URI apply(String value) {
                try {
                    return URI.create(value);
                }
                catch (IllegalArgumentException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, false);
    }

    public Set<Link> getLinks() {
        List links = (List)this.headers.get((Object)"Link");
        if (links == null || links.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            HashSet<Link> result = new HashSet<Link>(links.size());
            for (String l : links) {
                result.add(Link.valueOf((String)l));
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            throw InboundMessageContext.exception("Link", links, e);
        }
    }

    public boolean hasLink(String relation) {
        for (Link link : this.getLinks()) {
            List relations = link.getRel();
            if (relations == null || !relations.contains(relation)) continue;
            return true;
        }
        return false;
    }

    public Link getLink(String relation) {
        for (Link link : this.getLinks()) {
            List relations = link.getRel();
            if (relations == null || !relations.contains(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public MessageBodyWorkers getWorkers() {
        return this.workers;
    }

    public void setWorkers(MessageBodyWorkers workers) {
        this.workers = workers;
    }

    public boolean hasEntity() {
        return !this.contentStream.isEmpty();
    }

    public InputStream getEntityStream() {
        return this.contentStream.getInputStream();
    }

    public void setEntityStream(InputStream input) {
        this.contentStream.setExternalContentStream(input);
    }

    public <T> T readEntity(Class<T> rawType, PropertiesDelegate propertiesDelegate) {
        return this.readEntity(rawType, rawType, EMPTY_ANNOTATIONS, propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Annotation[] annotations, PropertiesDelegate propertiesDelegate) {
        return this.readEntity(rawType, rawType, annotations, propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Type type, PropertiesDelegate propertiesDelegate) {
        return this.readEntity(rawType, type, EMPTY_ANNOTATIONS, propertiesDelegate);
    }

    public <T> T readEntity(Class<T> rawType, Type type, Annotation[] annotations, PropertiesDelegate propertiesDelegate) {
        if (this.contentStream.isEmpty()) {
            return null;
        }
        if (this.workers == null) {
            return null;
        }
        try {
            Object t = this.workers.readFrom(rawType, type, annotations, this.getMediaType(), this.headers, propertiesDelegate, this.contentStream.getInputStream(), this.contentStream.getType().intercept());
            if (this.contentStream.getType() == ContentStream.Type.BUFFERED || this.contentStream.getType() == ContentStream.Type.EXTERNAL_BUFFERED) {
                this.contentStream.getInputStream().reset();
            } else if (!(t instanceof Closeable) && !(t instanceof Source)) {
                this.contentStream.invalidateContentStream();
            }
            return (T)t;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, LocalizationMessages.ERROR_READING_ENTITY_FROM_INPUT_STREAM(), ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bufferEntity() throws MessageProcessingException {
        try {
            if (this.contentStream.getType() == ContentStream.Type.BUFFERED || this.contentStream.getType() == ContentStream.Type.EXTERNAL_BUFFERED) {
                return true;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ReaderWriter.writeTo(this.contentStream.getInputStream(), baos);
            }
            finally {
                this.contentStream.invalidateContentStream();
            }
            this.contentStream.setBufferedContentStream(new ByteArrayInputStream(baos.toByteArray()));
            return true;
        }
        catch (IOException ex) {
            throw new MessageProcessingException(LocalizationMessages.MESSAGE_CONTENT_BUFFERING_FAILED(), (Throwable)ex);
        }
    }

    public void close() {
        this.contentStream.close();
    }

    private static class ContentStream {
        private InputStream contentStream;
        private Type type;
        private boolean closed;

        ContentStream(InputStream contentStream) {
            this.contentStream = contentStream;
            this.type = Type.INTERNAL;
        }

        void setBufferedContentStream(InputStream bufferedInputStream) {
            this.contentStream = bufferedInputStream;
            this.type = this.type == Type.EXTERNAL ? Type.EXTERNAL_BUFFERED : Type.BUFFERED;
        }

        void setExternalContentStream(InputStream contentStream) {
            this.contentStream = contentStream;
            this.type = Type.EXTERNAL;
        }

        InputStream getInputStream() {
            return this.contentStream;
        }

        Type getType() {
            return this.type;
        }

        void invalidateContentStream() {
            if (this.contentStream != null) {
                try {
                    this.contentStream.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), ex);
                }
                this.contentStream = null;
            }
        }

        void close() {
            if (!this.closed) {
                try {
                    this.contentStream.close();
                    this.closed = true;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, LocalizationMessages.MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED(), ex);
                }
            }
        }

        public boolean isEmpty() {
            if (this.closed) {
                throw new MessageProcessingException(LocalizationMessages.ERROR_ENTITY_STREAM_CLOSED());
            }
            if (this.contentStream == null) {
                return true;
            }
            try {
                PushbackInputStream pbis;
                if (this.contentStream.available() > 0) {
                    return false;
                }
                if (this.contentStream.markSupported()) {
                    this.contentStream.mark(1);
                    int i = this.contentStream.read();
                    this.contentStream.reset();
                    return i == -1;
                }
                int b = this.contentStream.read();
                if (b == -1) {
                    return true;
                }
                if (this.contentStream instanceof PushbackInputStream) {
                    pbis = (PushbackInputStream)this.contentStream;
                } else {
                    pbis = new PushbackInputStream(this.contentStream, 1);
                    this.contentStream = pbis;
                }
                pbis.unread(b);
                return false;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public static enum Type {
            EXTERNAL(true),
            INTERNAL(false),
            BUFFERED(false),
            EXTERNAL_BUFFERED(true),
            TEMP_BUFFERED(false);

            private final boolean intercept;

            private Type(boolean intercept) {
                this.intercept = intercept;
            }

            public boolean intercept() {
                return this.intercept;
            }
        }
    }
}

