/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.process.internal.AsyncInflectorAdapter;
import org.glassfish.jersey.process.internal.ExecutorsFactory;
import org.glassfish.jersey.process.internal.InflectorNotFoundException;
import org.glassfish.jersey.process.internal.InvocationCallback;
import org.glassfish.jersey.process.internal.InvocationContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.ResponseProcessor;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

public class RequestInvoker<REQUEST, RESPONSE> {
    private static final InvocationCallback EMPTY_CALLBACK = new InvocationCallback(){

        public void result(Object response) {
        }

        @Override
        public void failure(Throwable exception) {
        }

        @Override
        public void suspended(long time, TimeUnit unit, InvocationContext context) {
        }

        @Override
        public void suspendTimeoutChanged(long time, TimeUnit unit) {
        }

        @Override
        public void resumed() {
        }

        @Override
        public void cancelled() {
        }
    };
    private final Stage<REQUEST> rootStage;
    private final RequestScope requestScope;
    private final AsyncInflectorAdapter.Builder<REQUEST, RESPONSE> asyncAdapterBuilder;
    private final ResponseProcessor.Builder<RESPONSE> responseProcessorBuilder;
    private final Provider<Ref<InvocationContext>> invocationContextReferenceFactory;
    private final ExecutorsFactory<REQUEST> executorsFactory;

    public RequestInvoker(Stage<REQUEST> rootStage, RequestScope requestScope, AsyncInflectorAdapter.Builder<REQUEST, RESPONSE> asyncAdapterBuilder, ResponseProcessor.Builder<RESPONSE> responseProcessorBuilder, Provider<Ref<InvocationContext>> invocationContextReferenceFactory, ExecutorsFactory<REQUEST> executorsFactory) {
        this.requestScope = requestScope;
        this.rootStage = rootStage;
        this.asyncAdapterBuilder = asyncAdapterBuilder;
        this.responseProcessorBuilder = responseProcessorBuilder;
        this.invocationContextReferenceFactory = invocationContextReferenceFactory;
        this.executorsFactory = executorsFactory;
    }

    public ListenableFuture<RESPONSE> apply(REQUEST request) {
        return this.apply(request, EMPTY_CALLBACK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<RESPONSE> apply(final REQUEST request, final InvocationCallback<RESPONSE> callback) {
        final RequestScope.Instance instance = this.requestScope.createInstance();
        final SettableFuture result = SettableFuture.create();
        final Runnable requester = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AsyncInflectorAdapter asyncAdapter = RequestInvoker.this.asyncAdapterBuilder.create(new AcceptingInvoker(), callback);
                ResponseProcessor responseProcessor = RequestInvoker.this.responseProcessorBuilder.build(asyncAdapter, result, callback, instance);
                ((Ref)RequestInvoker.this.invocationContextReferenceFactory.get()).set(asyncAdapter);
                try {
                    asyncAdapter.apply(request);
                }
                finally {
                    asyncAdapter.addListener(responseProcessor, RequestInvoker.this.executorsFactory.getRespondingExecutor(request));
                }
            }
        };
        try {
            try {
                this.executorsFactory.getRequestingExecutor(request).submit(new Runnable(){

                    @Override
                    public void run() {
                        RequestInvoker.this.requestScope.runInScope(instance, requester);
                    }
                });
                return result;
            }
            catch (RejectedExecutionException ex) {
                throw new ProcessingException(LocalizationMessages.REQUEST_EXECUTION_FAILED(), ex);
            }
        }
        catch (ProcessingException ex) {
            try {
                SettableFuture failedResponse = SettableFuture.create();
                failedResponse.setException((Throwable)ex);
                SettableFuture settableFuture = failedResponse;
                return settableFuture;
            }
            finally {
                callback.failure(ex);
            }
        }
    }

    private class AcceptingInvoker
    implements Inflector<REQUEST, RESPONSE> {
        private AcceptingInvoker() {
        }

        @Override
        public RESPONSE apply(REQUEST request) {
            Stage currentStage;
            Stage lastStage = null;
            Stage.Continuation continuation = Stage.Continuation.of(request, RequestInvoker.this.rootStage);
            while ((currentStage = continuation.next()) != null) {
                lastStage = currentStage;
                continuation = currentStage.apply(continuation.result());
            }
            Inflector inflector = Stages.extractInflector(lastStage);
            Object result = continuation.result();
            Preconditions.checkState((lastStage != null ? 1 : 0) != 0, (Object)"No stage has been invoked as part of the processing.");
            if (inflector == null) {
                throw new InflectorNotFoundException("Terminal stage did not provide an inflector");
            }
            return inflector.apply(result);
        }
    }
}

