/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.AbstractMultivaluedMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.RuntimeDelegate;
import org.glassfish.jersey.internal.util.collection.ImmutableMultivaluedMap;
import org.glassfish.jersey.internal.util.collection.StringKeyIgnoreCaseMultivaluedMap;

public final class HeadersFactory {
    public static AbstractMultivaluedMap<String, String> createInbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<String>();
    }

    public static AbstractMultivaluedMap<String, String> createInbound(MultivaluedMap<String, String> initial) {
        AbstractMultivaluedMap<String, String> headers = HeadersFactory.createInbound();
        headers.putAll(initial);
        return headers;
    }

    public static AbstractMultivaluedMap<String, String> createInbound(Map<String, List<String>> initial) {
        AbstractMultivaluedMap<String, String> headers = HeadersFactory.createInbound();
        headers.putAll(initial);
        return headers;
    }

    public static <V> MultivaluedMap<String, V> empty() {
        return ImmutableMultivaluedMap.empty();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound() {
        return new StringKeyIgnoreCaseMultivaluedMap<Object>();
    }

    public static AbstractMultivaluedMap<String, Object> createOutbound(Map<String, List<Object>> initial) {
        AbstractMultivaluedMap<String, Object> headers = HeadersFactory.createOutbound();
        headers.putAll(initial);
        return headers;
    }

    public static String toString(Object headerValue, RuntimeDelegate rd) {
        RuntimeDelegate.HeaderDelegate hp;
        if (headerValue instanceof String) {
            return (String)headerValue;
        }
        if (rd == null) {
            rd = RuntimeDelegate.getInstance();
        }
        return (hp = rd.createHeaderDelegate(headerValue.getClass())) != null ? hp.toString(headerValue) : headerValue.toString();
    }

    public static List<String> toString(List<Object> headerValues, final RuntimeDelegate rd) {
        return new LinkedList<String>(Lists.transform(headerValues, (Function)new Function<Object, String>(){

            public String apply(Object input) {
                return input == null ? "[null]" : HeadersFactory.toString(input, rd);
            }
        }));
    }

    public static MultivaluedMap<String, String> toString(MultivaluedMap<String, Object> headers, final RuntimeDelegate rd) {
        return HeadersFactory.createInbound(Maps.transformValues(headers, (Function)new Function<List<Object>, List<String>>(){

            public List<String> apply(List<Object> input) {
                return input == null ? Collections.singletonList("[null]") : HeadersFactory.toString(input, rd);
            }
        }));
    }

    private HeadersFactory() {
    }

    public static MultivaluedMap<String, String> getStringHeaders(MultivaluedMap<String, Object> headers) {
        AbstractMultivaluedMap<String, String> stringHeaders = HeadersFactory.createInbound();
        if (!headers.isEmpty()) {
            stringHeaders.putAll(HeadersFactory.toString(headers, RuntimeDelegate.getInstance()));
        }
        return stringHeaders;
    }
}

