/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import org.glassfish.hk2.Services;
import org.glassfish.hk2.scopes.Singleton;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.spi.ProcessingExecutorsProvider;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;

@Scoped(value=Singleton.class)
public class ProcessingExecutorsFactory
implements ProcessingExecutorsProvider {
    private static final Logger LOGGER = Logger.getLogger(ProcessingExecutorsFactory.class.getName());
    private final ExecutorService requestingExecutor;
    private final ExecutorService respondingExecutor;

    ProcessingExecutorsFactory(@Inject Services services) {
        Set<ProcessingExecutorsProvider> providers = Providers.getProviders(services, ProcessingExecutorsProvider.class);
        this.requestingExecutor = ProcessingExecutorsFactory.createRequestingExecutor(providers);
        this.respondingExecutor = ProcessingExecutorsFactory.createRespondingExecutor(providers);
    }

    private static ExecutorService createRequestingExecutor(Set<ProcessingExecutorsProvider> providers) {
        for (ProcessingExecutorsProvider provider : providers) {
            ExecutorService es = provider.getRequestingExecutor();
            if (es == null) continue;
            LOGGER.config(String.format("Using custom requesting executor [%s] provided by [%s].", es.getClass().getName(), provider.getClass().getName()));
            return es;
        }
        LOGGER.config("Using default requesting executor.");
        return MoreExecutors.sameThreadExecutor();
    }

    private static ExecutorService createRespondingExecutor(Set<ProcessingExecutorsProvider> providers) {
        for (ProcessingExecutorsProvider provider : providers) {
            ExecutorService es = provider.getRespondingExecutor();
            if (es == null) continue;
            LOGGER.config(String.format("Using custom responding executor [%s] provided by [%s].", es.getClass().getName(), provider.getClass().getName()));
            return es;
        }
        LOGGER.config("Using default responding executor.");
        return MoreExecutors.sameThreadExecutor();
    }

    @Override
    public ExecutorService getRequestingExecutor() {
        return this.requestingExecutor;
    }

    @Override
    public ExecutorService getRespondingExecutor() {
        return this.respondingExecutor;
    }
}

