/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.process.internal;

import java.util.Comparator;
import javax.ws.rs.BindingPriority;

public class PriorityComparator<T>
implements Comparator<T> {
    private Order order;

    public PriorityComparator(Order order) {
        this.order = order;
    }

    @Override
    public int compare(T o1, T o2) {
        return (this.getPriority(o1) - this.getPriority(o2)) * this.order.ordering;
    }

    private int getPriority(T o) {
        if (o.getClass().isAnnotationPresent(BindingPriority.class)) {
            return o.getClass().getAnnotation(BindingPriority.class).value();
        }
        return 500;
    }

    public static enum Order {
        ASCENDING(1),
        DESCENDING(-1);

        private int ordering;

        private Order(int ordering) {
            this.ordering = ordering;
        }
    }
}

