/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public class PropertiesHelper {
    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue) {
        return PropertiesHelper.getValue(properties, key, defaultValue, defaultValue.getClass());
    }

    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue, Class<T> type) {
        T value = PropertiesHelper.getValue(properties, key, type);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static <T> T getValue(Map<String, ?> properties, String key, Class<T> type) {
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        if (!type.isInstance(value)) {
            Method valueOf;
            Constructor constructor = ReflectionHelper.getStringConstructor(type);
            if (constructor != null) {
                try {
                    return type.cast(constructor.newInstance(value));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((valueOf = ReflectionHelper.getValueOfStringMethod(type)) != null) {
                try {
                    return type.cast(valueOf.invoke(null, value));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        return type.cast(value);
    }
}

