/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.NameBinding;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.NameBound;
import org.glassfish.jersey.model.Scoped;

public final class ContractProvider
implements Scoped,
NameBound {
    public static final int NO_PRIORITY = -1;
    private final Set<Class<?>> contracts;
    private final int priority;
    private final Set<Class<? extends Annotation>> nameBindings;
    private final Class<? extends Annotation> scope;

    public static ContractProvider from(Class<?> serviceClass) {
        Builder<?> builder = ContractProvider.introspectService(serviceClass);
        return builder == null ? null : builder.build();
    }

    public static ContractProvider from(Object service) {
        return ContractProvider.from(service.getClass());
    }

    private static Builder<?> introspectService(Class<?> serviceClass) {
        Set<Class<?>> providerContracts = Providers.getProviderContracts(serviceClass);
        if (providerContracts.isEmpty()) {
            return null;
        }
        Builder builder = ContractProvider.builder().addContracts(providerContracts);
        for (Annotation annotation : serviceClass.getAnnotations()) {
            if (annotation instanceof BindingPriority) {
                builder.priority(((BindingPriority)annotation).value());
                continue;
            }
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (metaAnnotation instanceof NameBinding) {
                    builder.addNameBinding(annotation.annotationType());
                }
                if (!(metaAnnotation instanceof Scope)) continue;
                builder.scope(annotation.annotationType());
            }
        }
        return builder;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(ContractProvider original) {
        return new Builder(original);
    }

    private ContractProvider(Class<? extends Annotation> scope, Set<Class<?>> contracts, int priority, Set<Class<? extends Annotation>> nameBindings) {
        this.scope = scope;
        this.contracts = contracts;
        this.priority = priority;
        this.nameBindings = nameBindings;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public Set<Class<?>> getContracts() {
        return this.contracts;
    }

    @Override
    public boolean isNameBound() {
        return !this.nameBindings.isEmpty();
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<Class<? extends Annotation>> getNameBindings() {
        return this.nameBindings;
    }

    public static final class Builder<T> {
        private Class<? extends Annotation> scope = Singleton.class;
        private Set<Class<?>> contracts = Sets.newIdentityHashSet();
        private int priority = -1;
        private Set<Class<? extends Annotation>> nameBindings = Sets.newIdentityHashSet();

        private Builder() {
        }

        private Builder(ContractProvider original) {
            this.scope = original.scope;
            this.contracts.addAll(original.contracts);
            this.priority = original.priority;
            this.nameBindings.addAll(original.nameBindings);
        }

        public Builder<T> scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            return this;
        }

        public Builder<T> addContract(Class<? super T> contract) {
            this.contracts.add(contract);
            return this;
        }

        private Builder<T> addContracts(Collection<Class<?>> contracts) {
            this.contracts.addAll(contracts);
            return this;
        }

        public Builder<T> priority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder<T> addNameBinding(Class<? extends Annotation> binding) {
            this.nameBindings.add(binding);
            return this;
        }

        public ContractProvider build() {
            return new ContractProvider(this.scope, this.contracts, this.priority, this.nameBindings);
        }
    }
}

