/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ScopedBindingBuilder;
import org.glassfish.jersey.model.ContractProvider;

public class ProviderBinder {
    private final ServiceLocator locator;

    public ProviderBinder(ServiceLocator locator) {
        this.locator = locator;
    }

    public void bindInstances(Set<Object> instances) {
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Object instance : instances) {
            this.bindInstance(instance, dc);
        }
        dc.commit();
    }

    public void bindClasses(Class<?> ... classes) {
        if (classes != null && classes.length > 0) {
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            for (Class<?> clazz : classes) {
                this.bindClass(clazz, this.locator, dc, false);
            }
            dc.commit();
        }
    }

    public void bindClasses(Iterable<Class<?>> classes) {
        this.bindClasses(classes, false);
    }

    public void bindClasses(Iterable<Class<?>> classes, boolean bindResources) {
        if (classes == null || !classes.iterator().hasNext()) {
            return;
        }
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Class<?> clazz : classes) {
            this.bindClass(clazz, this.locator, dc, bindResources);
        }
        dc.commit();
    }

    public static void bindProvider(Class<?> providerClass, ContractProvider provider, DynamicConfiguration dc) {
        ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(providerClass).in(provider.getScope()).qualifiedBy(new CustomAnnotationImpl());
        for (Class<?> contract : provider.getContracts()) {
            bindingBuilder.to(contract);
        }
        Injections.addBinding(bindingBuilder, dc);
    }

    public static void bindProvider(Object providerInstance, ContractProvider provider, DynamicConfiguration dc) {
        ScopedBindingBuilder<Object> bindingBuilder = Injections.newBinder(providerInstance).qualifiedBy(new CustomAnnotationImpl());
        for (Class<?> contract : provider.getContracts()) {
            bindingBuilder.to(contract);
        }
        Injections.addBinding(bindingBuilder, dc);
    }

    private <T> void bindInstance(T instance, DynamicConfiguration dc) {
        for (Class<?> contract : Providers.getProviderContracts(instance.getClass())) {
            Injections.addBinding(Injections.newBinder(instance).to(contract).qualifiedBy(new CustomAnnotationImpl()), dc);
        }
    }

    private <T> void bindClass(Class<T> clazz, ServiceLocator locator, DynamicConfiguration dc, boolean isResource) {
        Class<? extends Annotation> scope = this.getProviderScope(clazz);
        if (isResource) {
            ActiveDescriptor descriptor = dc.bind((Descriptor)BuilderHelper.activeLink(clazz).to(clazz).in(scope).build());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.addQualifierAnnotation((Annotation)new CustomAnnotationImpl());
                dc.bind((Descriptor)aliasDescriptor);
            }
        } else {
            ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(clazz).in(scope).qualifiedBy(new CustomAnnotationImpl());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                bindingBuilder.to(contract);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    private Class<? extends Annotation> getProviderScope(Class<?> clazz) {
        Class<Singleton> hk2Scope = Singleton.class;
        if (clazz.isAnnotationPresent(PerLookup.class)) {
            hk2Scope = PerLookup.class;
        }
        return hk2Scope;
    }
}

