/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.jersey.internal.inject.NamedBindingBuilder;
import org.glassfish.jersey.internal.inject.ScopedBindingBuilder;
import org.glassfish.jersey.internal.inject.ScopedNamedBindingBuilder;
import org.glassfish.jersey.internal.inject.ServiceBindingBuilder;

abstract class AbstractBindingBuilder<T>
implements ServiceBindingBuilder<T>,
NamedBindingBuilder<T>,
ScopedBindingBuilder<T>,
ScopedNamedBindingBuilder<T> {
    Set<Type> contracts = new HashSet<Type>();
    HK2Loader loader = null;
    Multimap<String, String> metadata = HashMultimap.create();
    Set<Annotation> qualifiers = new HashSet<Annotation>();
    Class<? extends Annotation> scope = null;
    Integer ranked = null;
    String name = null;

    AbstractBindingBuilder() {
    }

    @Override
    public AbstractBindingBuilder<T> to(Class<? super T> contract) {
        this.contracts.add(contract);
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> to(TypeLiteral<?> contract) {
        this.contracts.add(contract.getType());
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> loadedBy(HK2Loader loader) {
        this.loader = loader;
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> withMetadata(String key, String value) {
        this.metadata.put((Object)key, (Object)value);
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> withMetadata(String key, List<String> values) {
        this.metadata.putAll((Object)key, values);
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> qualifiedBy(Annotation annotation) {
        this.qualifiers.add(annotation);
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> in(Class<? extends Annotation> scopeAnnotation) {
        this.scope = scopeAnnotation;
        return this;
    }

    @Override
    public AbstractBindingBuilder<T> named(String name) {
        this.name = name;
        return this;
    }

    @Override
    public void ranked(int rank) {
        this.ranked = rank;
    }

    abstract void complete(DynamicConfiguration var1, HK2Loader var2);

    static <T> AbstractBindingBuilder<T> create(Class<T> serviceType, boolean bindAsContract) {
        return new ClassBasedBindingBuilder<T>(serviceType, bindAsContract ? serviceType : null);
    }

    static <T> AbstractBindingBuilder<T> create(TypeLiteral<T> serviceType, boolean bindAsContract) {
        return new ClassBasedBindingBuilder(serviceType.getRawType(), bindAsContract ? serviceType.getType() : null);
    }

    static <T> AbstractBindingBuilder<T> create(T service) {
        return new InstanceBasedBindingBuilder<T>(service);
    }

    static <T> AbstractBindingBuilder<T> createFactoryBinder(Factory<T> factory) {
        return new FactoryInstanceBasedBindingBuilder<T>(factory);
    }

    static <T> AbstractBindingBuilder<T> createFactoryBinder(Class<? extends Factory<T>> factoryType, Class<? extends Annotation> factoryScope) {
        return new FactoryTypeBasedBindingBuilder(factoryType, factoryScope);
    }

    private static class FactoryDescriptorsImpl
    implements FactoryDescriptors {
        private final Descriptor serviceDescriptor;
        private final Descriptor factoryDescriptor;

        public FactoryDescriptorsImpl(Descriptor serviceDescriptor, Descriptor factoryDescriptor) {
            this.serviceDescriptor = serviceDescriptor;
            this.factoryDescriptor = factoryDescriptor;
        }

        public Descriptor getFactoryAsAService() {
            return this.serviceDescriptor;
        }

        public Descriptor getFactoryAsAFactory() {
            return this.factoryDescriptor;
        }

        public String toString() {
            return "FactoryDescriptorsImpl(\n" + this.serviceDescriptor + ",\n" + this.factoryDescriptor + ",\n\t" + System.identityHashCode(this) + ")";
        }
    }

    private static class FactoryTypeBasedBindingBuilder<T>
    extends AbstractBindingBuilder<T> {
        private final Class<? extends Factory<T>> factoryClass;
        private final Class<? extends Annotation> factoryScope;

        public FactoryTypeBasedBindingBuilder(Class<? extends Factory<T>> factoryClass, Class<? extends Annotation> factoryScope) {
            this.factoryClass = factoryClass;
            this.factoryScope = factoryScope;
        }

        @Override
        void complete(DynamicConfiguration configuration, HK2Loader defaultLoader) {
            if (this.loader == null) {
                this.loader = defaultLoader;
            }
            ActiveDescriptorBuilder factoryDescriptorBuilder = BuilderHelper.activeLink(this.factoryClass).named(this.name).andLoadWith(this.loader);
            if (this.factoryScope != null) {
                factoryDescriptorBuilder.in(this.factoryScope);
            }
            ActiveDescriptorBuilder descriptorBuilder = BuilderHelper.activeLink(this.factoryClass).named(this.name).andLoadWith(this.loader);
            if (this.scope != null) {
                descriptorBuilder.in(this.scope);
            }
            if (this.ranked != null) {
                descriptorBuilder.ofRank(this.ranked.intValue());
            }
            for (Annotation qualifier : this.qualifiers) {
                factoryDescriptorBuilder.qualifiedBy(qualifier);
                descriptorBuilder.qualifiedBy(qualifier);
            }
            for (Type contract : this.contracts) {
                factoryDescriptorBuilder.to((Type)new ParameterizedTypeImpl(Factory.class, new Type[]{contract}));
                descriptorBuilder.to(contract);
            }
            configuration.bind((FactoryDescriptors)new FactoryDescriptorsImpl((Descriptor)factoryDescriptorBuilder.build(), (Descriptor)descriptorBuilder.buildFactory()));
        }
    }

    private static class FactoryInstanceBasedBindingBuilder<T>
    extends AbstractBindingBuilder<T> {
        private final Factory<T> factory;

        public FactoryInstanceBasedBindingBuilder(Factory<T> factory) {
            this.factory = factory;
        }

        @Override
        void complete(DynamicConfiguration configuration, HK2Loader defaultLoader) {
            if (this.loader == null) {
                this.loader = defaultLoader;
            }
            AbstractActiveDescriptor factoryContractDescriptor = BuilderHelper.createConstantDescriptor(this.factory);
            factoryContractDescriptor.addContractType(this.factory.getClass());
            factoryContractDescriptor.setName(this.name);
            factoryContractDescriptor.setLoader(this.loader);
            ActiveDescriptorBuilder descriptorBuilder = BuilderHelper.activeLink(this.factory.getClass()).named(this.name).andLoadWith(this.loader);
            if (this.scope != null) {
                descriptorBuilder.in(this.scope);
            }
            if (this.ranked != null) {
                descriptorBuilder.ofRank(this.ranked.intValue());
            }
            for (Annotation qualifier : this.qualifiers) {
                factoryContractDescriptor.addQualifierAnnotation(qualifier);
                descriptorBuilder.qualifiedBy(qualifier);
            }
            for (Type contract : this.contracts) {
                factoryContractDescriptor.addContractType((Type)new ParameterizedTypeImpl(Factory.class, new Type[]{contract}));
                descriptorBuilder.to(contract);
            }
            configuration.bind((FactoryDescriptors)new FactoryDescriptorsImpl((Descriptor)factoryContractDescriptor, (Descriptor)descriptorBuilder.buildFactory()));
        }
    }

    private static class InstanceBasedBindingBuilder<T>
    extends AbstractBindingBuilder<T> {
        private final T service;

        public InstanceBasedBindingBuilder(T service) {
            this.service = service;
        }

        @Override
        void complete(DynamicConfiguration configuration, HK2Loader defaultLoader) {
            if (this.loader == null) {
                this.loader = defaultLoader;
            }
            AbstractActiveDescriptor descriptor = BuilderHelper.createConstantDescriptor(this.service);
            descriptor.setName(this.name);
            descriptor.setLoader(this.loader);
            if (this.scope != null) {
                descriptor.setScope(this.scope.getName());
            }
            if (this.ranked != null) {
                descriptor.setRanking(this.ranked.intValue());
            }
            for (String key : this.metadata.keySet()) {
                for (String value : this.metadata.get((Object)key)) {
                    descriptor.addMetadata(key, value);
                }
            }
            for (Annotation annotation : this.qualifiers) {
                descriptor.addQualifierAnnotation(annotation);
            }
            for (Type contract : this.contracts) {
                descriptor.addContractType(contract);
            }
            configuration.bind((Descriptor)descriptor);
        }
    }

    private static class ClassBasedBindingBuilder<T>
    extends AbstractBindingBuilder<T> {
        private final Class<T> service;

        public ClassBasedBindingBuilder(Class<T> service, Type serviceContractType) {
            this.service = service;
            if (serviceContractType != null) {
                this.contracts.add(serviceContractType);
            }
        }

        @Override
        void complete(DynamicConfiguration configuration, HK2Loader defaultLoader) {
            if (this.loader == null) {
                this.loader = defaultLoader;
            }
            ActiveDescriptorBuilder builder = BuilderHelper.activeLink(this.service).named(this.name).andLoadWith(this.loader);
            if (this.scope != null) {
                builder.in(this.scope);
            }
            if (this.ranked != null) {
                builder.ofRank(this.ranked.intValue());
            }
            for (String key : this.metadata.keySet()) {
                for (String value : this.metadata.get((Object)key)) {
                    builder.has(key, value);
                }
            }
            for (Annotation annotation : this.qualifiers) {
                builder.qualifiedBy(annotation);
            }
            for (Type contract : this.contracts) {
                builder.to(contract);
            }
            configuration.bind((Descriptor)builder.build());
        }
    }
}

