/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.CompletableReader;
import org.glassfish.jersey.message.internal.ExceptionWrapperInterceptor;
import org.glassfish.jersey.message.internal.InterceptorExecutor;
import org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;

public final class ReaderInterceptorExecutor
extends InterceptorExecutor
implements ReaderInterceptorContext {
    public static final String INTERCEPTORS = "jersey.runtime.reader.interceptors";
    private InputStream inputStream;
    private final MultivaluedMap<String, String> headers;
    private final Iterator<ReaderInterceptor> iterator;

    public ReaderInterceptorExecutor(Class<?> rawType, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, PropertiesDelegate propertiesDelegate, InputStream inputStream, MessageBodyWorkers workers, boolean intercept) {
        super(rawType, type, annotations, mediaType, propertiesDelegate);
        this.headers = headers;
        this.inputStream = inputStream;
        ArrayList<ReaderInterceptor> effectiveInterceptors = new ArrayList<ReaderInterceptor>();
        Object readerInterceptorsProperty = propertiesDelegate.getProperty(INTERCEPTORS);
        List<ReaderInterceptor> readerInterceptors = readerInterceptorsProperty != null ? (List<ReaderInterceptor>)readerInterceptorsProperty : workers.getReaderInterceptors();
        for (ReaderInterceptor interceptor : readerInterceptors) {
            if (!intercept && !(interceptor instanceof ExceptionWrapperInterceptor)) continue;
            effectiveInterceptors.add(interceptor);
        }
        effectiveInterceptors.add(new TerminalReaderInterceptor(workers));
        this.iterator = effectiveInterceptors.iterator();
    }

    public ReaderInterceptor getNextInterceptor() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        return this.iterator.next();
    }

    public Object proceed() throws IOException {
        ReaderInterceptor nextInterceptor = this.getNextInterceptor();
        if (nextInterceptor == null) {
            throw new ProcessingException(LocalizationMessages.ERROR_INTERCEPTOR_READER_PROCEED());
        }
        return nextInterceptor.aroundReadFrom((ReaderInterceptorContext)this);
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    private static class TerminalReaderInterceptor
    implements ReaderInterceptor {
        private final MessageBodyWorkers workers;

        public TerminalReaderInterceptor(MessageBodyWorkers workers) {
            this.workers = workers;
        }

        public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
            MessageBodyReader bodyReader = this.workers.getMessageBodyReader(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType());
            if (bodyReader == null) {
                throw new MessageBodyProviderNotFoundException(LocalizationMessages.ERROR_NOTFOUND_MESSAGEBODYREADER(context.getMediaType(), context.getType(), context.getGenericType()));
            }
            Object entity = bodyReader.readFrom(context.getType(), context.getGenericType(), context.getAnnotations(), context.getMediaType(), context.getHeaders(), context.getInputStream());
            if (bodyReader instanceof CompletableReader) {
                entity = ((CompletableReader)bodyReader).complete(entity);
            }
            return entity;
        }
    }
}

