/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class FeatureBag {
    private final List<RegisteredFeature> registered;
    private final Set<RegisteredFeature> enabled = Sets.newIdentityHashSet();

    private FeatureBag(List<RegisteredFeature> registered, Set<RegisteredFeature> enabled) {
        this.registered = Collections.unmodifiableList(registered);
        this.enabled.addAll(enabled);
    }

    public List<RegisteredFeature> getUnconfiguredFeatures() {
        LinkedList registeredFeatures = Lists.newLinkedList(this.registered);
        for (RegisteredFeature feature : this.enabled) {
            registeredFeatures.remove(feature);
        }
        return registeredFeatures;
    }

    public Set<Feature> getEnabledFeatures() {
        Set enabledFeatures = Sets.newIdentityHashSet();
        for (RegisteredFeature feature : this.enabled) {
            if (feature.feature == null) continue;
            enabledFeatures.add(feature.feature);
        }
        return Collections.unmodifiableSet(enabledFeatures);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        return this.enabled.contains(new RegisteredFeature(featureClass, null));
    }

    public boolean isEnabled(Feature feature) {
        return this.enabled.contains(new RegisteredFeature(null, feature));
    }

    public void setEnabled(Feature feature) {
        this.enabled.add(new RegisteredFeature(feature.getClass(), null));
        this.enabled.add(new RegisteredFeature(null, feature));
    }

    public boolean isRegistered(RegisteredFeature registeredFeature) {
        return this.registered.contains(registeredFeature);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FeatureBag)) {
            return false;
        }
        FeatureBag other = (FeatureBag)obj;
        return this == other && (this.registered == other.registered || ((Object)this.registered).equals(other.registered));
    }

    public int hashCode() {
        int hash = 53;
        hash = 7 * hash + ((Object)this.registered).hashCode();
        return hash;
    }

    public static final class Builder {
        private final List<RegisteredFeature> registered = Lists.newLinkedList();
        private final Set<RegisteredFeature> enabled = Sets.newIdentityHashSet();
        private final MultivaluedMap<Class<? extends Feature>, RegisteredFeature> registeredFeatures = new MultivaluedHashMap();

        public Builder() {
        }

        public Builder(Builder other) {
            this.registered.addAll(other.registered);
            this.registeredFeatures.putAll(other.registeredFeatures);
            this.enabled.addAll(other.enabled);
        }

        public Builder(FeatureBag other) {
            this.registered.addAll(other.registered);
            for (RegisteredFeature registeredFeature : other.registered) {
                this.registeredFeatures.add(registeredFeature.featureClass != null ? registeredFeature.featureClass : registeredFeature.feature.getClass(), (Object)registeredFeature);
            }
            this.enabled.addAll(other.enabled);
        }

        public boolean add(Class<? extends Feature> featureClass) {
            if (!this.registeredFeatures.containsKey(featureClass)) {
                RegisteredFeature featureClassToRegister = new RegisteredFeature(featureClass, null);
                this.registeredFeatures.add(featureClass, (Object)featureClassToRegister);
                this.registered.add(featureClassToRegister);
                return true;
            }
            return false;
        }

        public boolean add(Feature feature) {
            Class<?> featureClass = feature.getClass();
            RegisteredFeature featureClassToRegister = new RegisteredFeature(featureClass, null);
            List registeredFeatures = (List)this.registeredFeatures.get(featureClass);
            if (registeredFeatures != null && registeredFeatures.contains(featureClassToRegister)) {
                registeredFeatures.remove(featureClassToRegister);
                this.registered.remove(featureClassToRegister);
            }
            RegisteredFeature featureToRegister = new RegisteredFeature(null, feature);
            this.registeredFeatures.add(feature.getClass(), (Object)featureToRegister);
            this.registered.add(featureToRegister);
            return true;
        }

        public FeatureBag build() {
            return new FeatureBag(this.registered, this.enabled);
        }
    }

    public static final class RegisteredFeature {
        private final Class<? extends Feature> featureClass;
        private final Feature feature;

        public RegisteredFeature(Class<? extends Feature> featureClass, Feature feature) {
            this.featureClass = featureClass;
            this.feature = feature;
        }

        public Class<? extends Feature> getFeatureClass() {
            return this.featureClass;
        }

        public Feature getFeature() {
            return this.feature;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RegisteredFeature)) {
                return false;
            }
            RegisteredFeature other = (RegisteredFeature)obj;
            return this == other || this.featureClass == other.featureClass || this.feature != null && (this.feature == other.feature || this.feature.equals(other.feature));
        }

        public int hashCode() {
            int hash = 47;
            hash = 13 * hash + (this.feature != null ? this.feature.hashCode() : 0);
            hash = 13 * hash + (this.featureClass != null ? this.featureClass.hashCode() : 0);
            return hash;
        }
    }
}

