/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.model.ContractProvider;

public final class ProviderBag {
    private final Set<Class<?>> classes;
    private final Set<Object> instances;
    private final Map<Class<?>, ContractProvider> models;

    private ProviderBag(Set<Class<?>> classes, Set<Object> instances, Map<Class<?>, ContractProvider> models) {
        this.classes = Collections.unmodifiableSet(classes);
        this.instances = Collections.unmodifiableSet(instances);
        this.models = Collections.unmodifiableMap(models);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getInstances() {
        return this.instances;
    }

    public Map<Class<?>, ContractProvider> getModels() {
        return this.models;
    }

    public ContractProvider getContractProvider(Class<?> providerClass) {
        return this.models.get(providerClass);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProviderBag)) {
            return false;
        }
        ProviderBag other = (ProviderBag)obj;
        return !(this != other || this.classes != other.classes && !((Object)this.classes).equals(other.classes) || this.instances != other.instances && !((Object)this.instances).equals(other.instances));
    }

    public int hashCode() {
        int hash = 37;
        hash = 47 * hash + ((Object)this.classes).hashCode();
        hash = 47 * hash + ((Object)this.instances).hashCode();
        return hash;
    }

    public static final class Builder {
        private final Set<Class<?>> classes = Sets.newIdentityHashSet();
        private final Set<Object> instances = Sets.newIdentityHashSet();
        private final Set<Class<?>> instanceClasses = Sets.newIdentityHashSet();
        private final Map<Class<?>, ContractProvider> models = Maps.newIdentityHashMap();

        public Builder() {
        }

        public Builder(Builder original) {
            this.classes.addAll(original.classes);
            this.instances.addAll(original.instances);
            this.instanceClasses.addAll(original.instanceClasses);
            this.models.putAll(original.models);
        }

        public Builder(ProviderBag original) {
            this.classes.addAll(original.getClasses());
            this.instances.addAll(original.getInstances());
            this.models.putAll(original.getModels());
            for (Object instance : original.getInstances()) {
                this.instanceClasses.add(instance.getClass());
            }
        }

        public ProviderBag build() {
            return new ProviderBag(this.classes, this.instances, this.models);
        }

        public boolean register(Class<?> providerClass, boolean isResource) {
            if (isResource) {
                ContractProvider model = ContractProvider.from(providerClass);
                if (model == null) {
                    return false;
                }
                this.models.put(providerClass, model);
                return true;
            }
            return this.register(providerClass, -1, Collections.<Class<?>>emptySet());
        }

        public boolean register(Class<?> providerClass, int bindingPriority, Set<Class<?>> contracts) {
            if (this.instanceClasses.contains(providerClass)) {
                return false;
            }
            boolean success = this.updateContractProvider(providerClass, bindingPriority, contracts);
            return success && this.classes.add(providerClass);
        }

        private boolean updateContractProvider(Class<?> providerClass, int bindingPriority, Set<Class<?>> contracts) {
            ContractProvider contractProvider = this.models.get(providerClass);
            if (contractProvider == null) {
                ContractProvider model = ContractProvider.from(providerClass, bindingPriority, contracts);
                if (model == null) {
                    return false;
                }
                this.models.put(providerClass, model);
            } else {
                Set<Class<?>> currentContracts = contractProvider.getContracts();
                ContractProvider.Builder builder = null;
                for (Class<?> contract : contracts) {
                    if (currentContracts.contains(contract) && contractProvider.getPriority(contract) != -1) continue;
                    builder = builder == null ? ContractProvider.builder(contractProvider) : builder;
                    builder.addContract(contract, bindingPriority);
                }
                if (builder != null) {
                    this.models.put(providerClass, builder.build());
                }
            }
            return true;
        }

        public boolean register(Object provider, boolean isResource) {
            if (isResource) {
                Class<?> providerClass = provider.getClass();
                ContractProvider model = ContractProvider.from(providerClass);
                if (model == null) {
                    return false;
                }
                this.models.put(providerClass, model);
                return true;
            }
            return this.register(provider, -1, Collections.<Class<?>>emptySet());
        }

        public boolean register(Object provider, int bindingPriority, Set<Class<?>> contracts) {
            boolean success;
            Class<?> providerClass = provider.getClass();
            if (this.classes.contains(providerClass) && !this.instanceClasses.contains(providerClass)) {
                this.classes.remove(providerClass);
                this.models.remove(providerClass);
            }
            return (success = this.updateContractProvider(providerClass, bindingPriority, contracts)) && this.instances.add(provider) && this.instanceClasses.add(providerClass);
        }
    }
}

