
package org.glassfish.jersey.internal;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableCACHE_CONTROL_IS_NULL() {
        return messageFactory.getMessage("cache.control.is.null");
    }

    /**
     * Cache control is null.
     * 
     */
    public static String CACHE_CONTROL_IS_NULL() {
        return localizer.localize(localizableCACHE_CONTROL_IS_NULL());
    }

    public static Localizable localizableSAX_XDK_NO_SECURITY_FEATURES() {
        return messageFactory.getMessage("sax.xdk.no.security.features");
    }

    /**
     * Using XDK. No security features will be enabled for the SAX parser.
     * 
     */
    public static String SAX_XDK_NO_SECURITY_FEATURES() {
        return localizer.localize(localizableSAX_XDK_NO_SECURITY_FEATURES());
    }

    public static Localizable localizableSTRING_IS_NULL() {
        return messageFactory.getMessage("string.is.null");
    }

    /**
     * String is null.
     * 
     */
    public static String STRING_IS_NULL() {
        return localizer.localize(localizableSTRING_IS_NULL());
    }

    public static Localizable localizableERROR_NOTFOUND_MESSAGEBODYWRITER(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("error.notfound.messagebodywriter", arg0, arg1, arg2);
    }

    /**
     * MessageBodyWriter not found for media type={0}, type={1}, genericType={2}.
     * 
     */
    public static String ERROR_NOTFOUND_MESSAGEBODYWRITER(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableERROR_NOTFOUND_MESSAGEBODYWRITER(arg0, arg1, arg2));
    }

    public static Localizable localizableMESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED() {
        return messageFactory.getMessage("message.content.input.stream.close.failed");
    }

    /**
     * Error closing message content input stream.
     * 
     */
    public static String MESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED() {
        return localizer.localize(localizableMESSAGE_CONTENT_INPUT_STREAM_CLOSE_FAILED());
    }

    public static Localizable localizablePROVIDER_CLASS_COULD_NOT_BE_LOADED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("provider.class.could.not.be.loaded", arg0, arg1, arg2);
    }

    /**
     * The class {0} implementing provider {1} could not be loaded: {2}
     * 
     */
    public static String PROVIDER_CLASS_COULD_NOT_BE_LOADED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizablePROVIDER_CLASS_COULD_NOT_BE_LOADED(arg0, arg1, arg2));
    }

    public static Localizable localizableEXCEPTION_MAPPER_SUPPORTED_TYPE_UNKNOWN(Object arg0) {
        return messageFactory.getMessage("exception.mapper.supported.type.unknown", arg0);
    }

    /**
     * Unable to retrieve the supported exception type for a registered exception mapper service class "{0}".
     * 
     */
    public static String EXCEPTION_MAPPER_SUPPORTED_TYPE_UNKNOWN(Object arg0) {
        return localizer.localize(localizableEXCEPTION_MAPPER_SUPPORTED_TYPE_UNKNOWN(arg0));
    }

    public static Localizable localizableERROR_READING_ENTITY_FROM_INPUT_STREAM() {
        return messageFactory.getMessage("error.reading.entity.from.input.stream");
    }

    /**
     * Error reading entity from input stream.
     * 
     */
    public static String ERROR_READING_ENTITY_FROM_INPUT_STREAM() {
        return localizer.localize(localizableERROR_READING_ENTITY_FROM_INPUT_STREAM());
    }

    public static Localizable localizableUSING_CUSTOM_REQUEST_EXECUTOR(Object arg0, Object arg1) {
        return messageFactory.getMessage("using.custom.request.executor", arg0, arg1);
    }

    /**
     * "Using custom requesting executor [{0}] provided by [{1}]."
     * 
     */
    public static String USING_CUSTOM_REQUEST_EXECUTOR(Object arg0, Object arg1) {
        return localizer.localize(localizableUSING_CUSTOM_REQUEST_EXECUTOR(arg0, arg1));
    }

    public static Localizable localizableREQUEST_CANCEL_FAILED(Object arg0) {
        return messageFactory.getMessage("request.cancel.failed", arg0);
    }

    /**
     * Failed to cancel request invocation context in state "{0}".
     * 
     */
    public static String REQUEST_CANCEL_FAILED(Object arg0) {
        return localizer.localize(localizableREQUEST_CANCEL_FAILED(arg0));
    }

    public static Localizable localizableDEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("dependent.class.of.provider.format.error", arg0, arg1, arg2);
    }

    /**
     * {0}. A dependent class of the class {1} implementing the provider {2} is malformed. The provider implementation is ignored. Check if the malformed class is part of a stubbed jar that used for compiling only.
     * 
     */
    public static String DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableDEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(arg0, arg1, arg2));
    }

    public static Localizable localizableMEDIA_TYPE_IS_NULL() {
        return messageFactory.getMessage("media.type.is.null");
    }

    /**
     * Media type is null.
     * 
     */
    public static String MEDIA_TYPE_IS_NULL() {
        return localizer.localize(localizableMEDIA_TYPE_IS_NULL());
    }

    public static Localizable localizableURI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(Object arg0, Object arg1) {
        return messageFactory.getMessage("uri.component.encoded.octet.invalid.digit", arg0, arg1);
    }

    /**
     * Malformed percent-encoded octet at index {0}, invalid hexadecimal digit ''{1}''.
     * 
     */
    public static String URI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(Object arg0, Object arg1) {
        return localizer.localize(localizableURI_COMPONENT_ENCODED_OCTET_INVALID_DIGIT(arg0, arg1));
    }

    public static Localizable localizablePROVIDER_NOT_ASSIGNABLE(Object arg0, Object arg1) {
        return messageFactory.getMessage("provider.not.assignable", arg0, arg1);
    }

    /**
     * Provider {0} can not be used because it is not assignable to {1}. This might be caused by clashing container-provided and application-bundled Jersey classes.
     * 
     */
    public static String PROVIDER_NOT_ASSIGNABLE(Object arg0, Object arg1) {
        return localizer.localize(localizablePROVIDER_NOT_ASSIGNABLE(arg0, arg1));
    }

    public static Localizable localizableILLEGAL_PROVIDER_CLASS_NAME(Object arg0) {
        return messageFactory.getMessage("illegal.provider.class.name", arg0);
    }

    /**
     * Illegal provider-class name: {0}.
     * 
     */
    public static String ILLEGAL_PROVIDER_CLASS_NAME(Object arg0) {
        return localizer.localize(localizableILLEGAL_PROVIDER_CLASS_NAME(arg0));
    }

    public static Localizable localizableUSING_DEFAULT_REQUEST_EXECUTOR(Object arg0) {
        return messageFactory.getMessage("using.default.request.executor", arg0);
    }

    /**
     * "Using default requesting executor [{0}]."
     * 
     */
    public static String USING_DEFAULT_REQUEST_EXECUTOR(Object arg0) {
        return localizer.localize(localizableUSING_DEFAULT_REQUEST_EXECUTOR(arg0));
    }

    public static Localizable localizableDATE_IS_NULL() {
        return messageFactory.getMessage("date.is.null");
    }

    /**
     * Date is null.
     * 
     */
    public static String DATE_IS_NULL() {
        return localizer.localize(localizableDATE_IS_NULL());
    }

    public static Localizable localizableCOOKIE_IS_NULL() {
        return messageFactory.getMessage("cookie.is.null");
    }

    /**
     * Cookie is null.
     * 
     */
    public static String COOKIE_IS_NULL() {
        return localizer.localize(localizableCOOKIE_IS_NULL());
    }

    public static Localizable localizableLINK_IS_NULL() {
        return messageFactory.getMessage("link.is.null");
    }

    /**
     * Link is null.
     * 
     */
    public static String LINK_IS_NULL() {
        return localizer.localize(localizableLINK_IS_NULL());
    }

    public static Localizable localizableERROR_PROCESSING_MESSAGEBODY() {
        return messageFactory.getMessage("error.processing.messagebody");
    }

    /**
     * Exception during processing (read/write) of the message body.
     * 
     */
    public static String ERROR_PROCESSING_MESSAGEBODY() {
        return localizer.localize(localizableERROR_PROCESSING_MESSAGEBODY());
    }

    public static Localizable localizableERROR_UNMARSHALLING_JAXB(Object arg0) {
        return messageFactory.getMessage("error.unmarshalling.jaxb", arg0);
    }

    /**
     * Error un-marshalling JAXB object of type: {0}.
     * 
     */
    public static String ERROR_UNMARSHALLING_JAXB(Object arg0) {
        return localizer.localize(localizableERROR_UNMARSHALLING_JAXB(arg0));
    }

    public static Localizable localizableURI_IS_NULL() {
        return messageFactory.getMessage("uri.is.null");
    }

    /**
     * Uri is null.
     * 
     */
    public static String URI_IS_NULL() {
        return localizer.localize(localizableURI_IS_NULL());
    }

    public static Localizable localizableENTITY_TAG_IS_NULL() {
        return messageFactory.getMessage("entity.tag.is.null");
    }

    /**
     * Entity tag is null.
     * 
     */
    public static String ENTITY_TAG_IS_NULL() {
        return localizer.localize(localizableENTITY_TAG_IS_NULL());
    }

    public static Localizable localizableNO_CONTAINER_AVAILABLE() {
        return messageFactory.getMessage("no.container.available");
    }

    /**
     * No container available.
     * 
     */
    public static String NO_CONTAINER_AVAILABLE() {
        return localizer.localize(localizableNO_CONTAINER_AVAILABLE());
    }

    public static Localizable localizableINVOCATION_FAILED(Object arg0) {
        return messageFactory.getMessage("invocation.failed", arg0);
    }

    /**
     * Invocation of a {0} method on a request execution callback has failed.
     * 
     */
    public static String INVOCATION_FAILED(Object arg0) {
        return localizer.localize(localizableINVOCATION_FAILED(arg0));
    }

    public static Localizable localizableERROR_INTERCEPTOR_READER_PROCEED() {
        return messageFactory.getMessage("error.interceptor.reader.proceed");
    }

    /**
     * Last reader interceptor in the chain called the method proceed.
     * 
     */
    public static String ERROR_INTERCEPTOR_READER_PROCEED() {
        return localizer.localize(localizableERROR_INTERCEPTOR_READER_PROCEED());
    }

    public static Localizable localizableUSING_CUSTOM_RESPONSE_EXECUTOR(Object arg0, Object arg1) {
        return messageFactory.getMessage("using.custom.response.executor", arg0, arg1);
    }

    /**
     * "Using custom responding executor [{0}] provided by [{1}]."
     * 
     */
    public static String USING_CUSTOM_RESPONSE_EXECUTOR(Object arg0, Object arg1) {
        return localizer.localize(localizableUSING_CUSTOM_RESPONSE_EXECUTOR(arg0, arg1));
    }

    public static Localizable localizableSAX_CANNOT_ENABLE_SECURITY_FEATURES() {
        return messageFactory.getMessage("sax.cannot.enable.security.features");
    }

    /**
     * Security features for the SAX parser could not be enabled.
     * 
     */
    public static String SAX_CANNOT_ENABLE_SECURITY_FEATURES() {
        return localizer.localize(localizableSAX_CANNOT_ENABLE_SECURITY_FEATURES());
    }

    public static Localizable localizableILLEGAL_INITIAL_CAPACITY(Object arg0) {
        return messageFactory.getMessage("illegal.initial.capacity", arg0);
    }

    /**
     * Illegal initial capacity: {0}.
     * 
     */
    public static String ILLEGAL_INITIAL_CAPACITY(Object arg0) {
        return localizer.localize(localizableILLEGAL_INITIAL_CAPACITY(arg0));
    }

    public static Localizable localizableUSING_DEFAULT_RESPONSE_EXECUTOR(Object arg0) {
        return messageFactory.getMessage("using.default.response.executor", arg0);
    }

    /**
     * "Using default responding executor [{0}]."
     * 
     */
    public static String USING_DEFAULT_RESPONSE_EXECUTOR(Object arg0) {
        return localizer.localize(localizableUSING_DEFAULT_RESPONSE_EXECUTOR(arg0));
    }

    public static Localizable localizableREQUEST_SUSPENDED_RESPONSE_IGNORED(Object arg0) {
        return messageFactory.getMessage("request.suspended.response.ignored", arg0);
    }

    /**
     * Request processing suspended - response returned by inflector ignored: {0}
     * 
     */
    public static String REQUEST_SUSPENDED_RESPONSE_IGNORED(Object arg0) {
        return localizer.localize(localizableREQUEST_SUSPENDED_RESPONSE_IGNORED(arg0));
    }

    public static Localizable localizableERROR_INTERCEPTOR_WRITER_PROCEED() {
        return messageFactory.getMessage("error.interceptor.writer.proceed");
    }

    /**
     * Last writer interceptor in the chain called the method proceed.
     * 
     */
    public static String ERROR_INTERCEPTOR_WRITER_PROCEED() {
        return localizer.localize(localizableERROR_INTERCEPTOR_WRITER_PROCEED());
    }

    public static Localizable localizableNEW_COOKIE_IS_NULL() {
        return messageFactory.getMessage("new.cookie.is.null");
    }

    /**
     * New cookie is null.
     * 
     */
    public static String NEW_COOKIE_IS_NULL() {
        return localizer.localize(localizableNEW_COOKIE_IS_NULL());
    }

    public static Localizable localizableERROR_NOTFOUND_MESSAGEBODYREADER(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("error.notfound.messagebodyreader", arg0, arg1, arg2);
    }

    /**
     * MessageBodyReader not found for media type={0}, type={1}, genericType={2}.
     * 
     */
    public static String ERROR_NOTFOUND_MESSAGEBODYREADER(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableERROR_NOTFOUND_MESSAGEBODYREADER(arg0, arg1, arg2));
    }

    public static Localizable localizableLOCALE_IS_NULL() {
        return messageFactory.getMessage("locale.is.null");
    }

    /**
     * Locale is null.
     * 
     */
    public static String LOCALE_IS_NULL() {
        return localizer.localize(localizableLOCALE_IS_NULL());
    }

    public static Localizable localizableDEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("dependent.class.of.provider.not.found", arg0, arg1, arg2);
    }

    /**
     * A dependent class, {0}, of the class {1} implementing the provider {2} is not found. The provider implementation is ignored.
     * 
     */
    public static String DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableDEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(arg0, arg1, arg2));
    }

    public static Localizable localizableERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return messageFactory.getMessage("error.caught.while.loading.spi.providers");
    }

    /**
     * Error caught while loading SPI providers.
     * 
     */
    public static String ERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return localizer.localize(localizableERROR_CAUGHT_WHILE_LOADING_SPI_PROVIDERS());
    }

    public static Localizable localizablePROVIDER_COULD_NOT_BE_CREATED(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("provider.could.not.be.created", arg0, arg1, arg2);
    }

    /**
     * The class {0} implementing provider {1} could not be instantiated: {2}
     * 
     */
    public static String PROVIDER_COULD_NOT_BE_CREATED(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizablePROVIDER_COULD_NOT_BE_CREATED(arg0, arg1, arg2));
    }

    public static Localizable localizableREQUEST_SUSPEND_FAILED(Object arg0) {
        return messageFactory.getMessage("request.suspend.failed", arg0);
    }

    /**
     * Failed to suspend request invocation context in state "{0}".
     * 
     */
    public static String REQUEST_SUSPEND_FAILED(Object arg0) {
        return localizer.localize(localizableREQUEST_SUSPEND_FAILED(arg0));
    }

    public static Localizable localizableUNABLE_TO_PARSE_HEADER_VALUE(Object arg0, Object arg1) {
        return messageFactory.getMessage("unable.to.parse.header.value", arg0, arg1);
    }

    /**
     * Unable to parse "{0}" header value: "{1}"
     * 
     */
    public static String UNABLE_TO_PARSE_HEADER_VALUE(Object arg0, Object arg1) {
        return localizer.localize(localizableUNABLE_TO_PARSE_HEADER_VALUE(arg0, arg1));
    }

    public static Localizable localizableMESSAGE_CONTENT_BUFFER_RESET_FAILED() {
        return messageFactory.getMessage("message.content.buffer.reset.failed");
    }

    /**
     * Error resetting the buffered message content input stream.
     * 
     */
    public static String MESSAGE_CONTENT_BUFFER_RESET_FAILED() {
        return localizer.localize(localizableMESSAGE_CONTENT_BUFFER_RESET_FAILED());
    }

    public static Localizable localizableILLEGAL_LOAD_FACTOR(Object arg0) {
        return messageFactory.getMessage("illegal.load.factor", arg0);
    }

    /**
     * Illegal load factor: {0}.
     * 
     */
    public static String ILLEGAL_LOAD_FACTOR(Object arg0) {
        return localizer.localize(localizableILLEGAL_LOAD_FACTOR(arg0));
    }

    public static Localizable localizableURI_COMPONENT_ENCODED_OCTET_MALFORMED(Object arg0) {
        return messageFactory.getMessage("uri.component.encoded.octet.malformed", arg0);
    }

    /**
     * Malformed percent-encoded octet at index {0}.
     * 
     */
    public static String URI_COMPONENT_ENCODED_OCTET_MALFORMED(Object arg0) {
        return localizer.localize(localizableURI_COMPONENT_ENCODED_OCTET_MALFORMED(arg0));
    }

    public static Localizable localizableILLEGAL_CONFIG_SYNTAX() {
        return messageFactory.getMessage("illegal.config.syntax");
    }

    /**
     * Illegal configuration-file syntax.
     * 
     */
    public static String ILLEGAL_CONFIG_SYNTAX() {
        return localizer.localize(localizableILLEGAL_CONFIG_SYNTAX());
    }

    public static Localizable localizableMESSAGE_CONTENT_BUFFERING_FAILED() {
        return messageFactory.getMessage("message.content.buffering.failed");
    }

    /**
     * Failed to buffer the message content input stream.
     * 
     */
    public static String MESSAGE_CONTENT_BUFFERING_FAILED() {
        return localizer.localize(localizableMESSAGE_CONTENT_BUFFERING_FAILED());
    }

    public static Localizable localizableTOO_MANY_HEADER_VALUES(Object arg0, Object arg1) {
        return messageFactory.getMessage("too.many.header.values", arg0, arg1);
    }

    /**
     * Too many "{0}" header values: "{1}"
     * 
     */
    public static String TOO_MANY_HEADER_VALUES(Object arg0, Object arg1) {
        return localizer.localize(localizableTOO_MANY_HEADER_VALUES(arg0, arg1));
    }

    public static Localizable localizableILLEGAL_INVOCATION_CONTEXT_STATE(Object arg0, Object arg1) {
        return messageFactory.getMessage("illegal.invocation.context.state", arg0, arg1);
    }

    /**
     * Invocation context is in illegal state "{0}" for "{1}" operation.
     * 
     */
    public static String ILLEGAL_INVOCATION_CONTEXT_STATE(Object arg0, Object arg1) {
        return localizer.localize(localizableILLEGAL_INVOCATION_CONTEXT_STATE(arg0, arg1));
    }

    public static Localizable localizableURI_COMPONENT_INVALID_CHARACTER(Object arg0, Object arg1, Object arg2, Object arg3) {
        return messageFactory.getMessage("uri.component.invalid.character", arg0, arg1, arg2, arg3);
    }

    /**
     * The string "{0}" for the URI component {1} contains an invalid character, ''{2}'', at index {3}.
     * 
     */
    public static String URI_COMPONENT_INVALID_CHARACTER(Object arg0, Object arg1, Object arg2, Object arg3) {
        return localizer.localize(localizableURI_COMPONENT_INVALID_CHARACTER(arg0, arg1, arg2, arg3));
    }

    public static Localizable localizableREQUEST_EXECUTION_FAILED() {
        return messageFactory.getMessage("request.execution.failed");
    }

    /**
     * Request execution has failed.
     * 
     */
    public static String REQUEST_EXECUTION_FAILED() {
        return localizer.localize(localizableREQUEST_EXECUTION_FAILED());
    }

    public static Localizable localizableCALLBACK_METHOD_INVOCATION_FAILED(Object arg0, Object arg1) {
        return messageFactory.getMessage("callback.method.invocation.failed", arg0, arg1);
    }

    /**
     * Invocation of a {0} method on a request execution callback has failed on thread {1}.
     * 
     */
    public static String CALLBACK_METHOD_INVOCATION_FAILED(Object arg0, Object arg1) {
        return localizer.localize(localizableCALLBACK_METHOD_INVOCATION_FAILED(arg0, arg1));
    }

    public static Localizable localizableEXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return messageFactory.getMessage("exception.caught.while.loading.spi.providers");
    }

    /**
     * Exception caught while loading SPI providers.
     * 
     */
    public static String EXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS() {
        return localizer.localize(localizableEXCEPTION_CAUGHT_WHILE_LOADING_SPI_PROVIDERS());
    }

    public static Localizable localizableSAX_CANNOT_ENABLE_SECURE_PROCESSING_FEATURE() {
        return messageFactory.getMessage("sax.cannot.enable.secure.processing.feature");
    }

    /**
     * JAXP feature XMLConstants.FEATURE_SECURE_PROCESSING cannot be set on a SAXParserFactory. External general entity processing is disabled but other potential security related features will not be enabled.
     * 
     */
    public static String SAX_CANNOT_ENABLE_SECURE_PROCESSING_FEATURE() {
        return localizer.localize(localizableSAX_CANNOT_ENABLE_SECURE_PROCESSING_FEATURE());
    }

    public static Localizable localizablePROVIDER_NOT_FOUND(Object arg0, Object arg1) {
        return messageFactory.getMessage("provider.not.found", arg0, arg1);
    }

    /**
     * The class {0} implementing the provider {1} is not found. The provider implementation is ignored.
     * 
     */
    public static String PROVIDER_NOT_FOUND(Object arg0, Object arg1) {
        return localizer.localize(localizablePROVIDER_NOT_FOUND(arg0, arg1));
    }

    public static Localizable localizableTYPE_TO_CLASS_CONVERSION_NOT_SUPPORTED(Object arg0) {
        return messageFactory.getMessage("type.to.class.conversion.not.supported", arg0);
    }

    /**
     * Type-to-class conversion not supported for: {0}.
     * 
     */
    public static String TYPE_TO_CLASS_CONVERSION_NOT_SUPPORTED(Object arg0) {
        return localizer.localize(localizableTYPE_TO_CLASS_CONVERSION_NOT_SUPPORTED(arg0));
    }

    public static Localizable localizableERROR_ENTITY_STREAM_CLOSED() {
        return messageFactory.getMessage("error.entity.stream.closed");
    }

    /**
     * Entity input stream has already been closed.
     * 
     */
    public static String ERROR_ENTITY_STREAM_CLOSED() {
        return localizer.localize(localizableERROR_ENTITY_STREAM_CLOSED());
    }

}
