/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.lang.reflect.ReflectPermission;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.OsgiRegistry;
import org.glassfish.jersey.internal.ServiceConfigurationError;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public final class ServiceFinder<T>
implements Iterable<T> {
    private static final Logger LOGGER = Logger.getLogger(ServiceFinder.class.getName());
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MODULE_VERSION = "META-INF/jersey-module-version";
    private static final String PREFIX = "META-INF/services/";
    private static final String BUNDLE_VERSION_ATTRIBUTE = "Bundle-Version";
    private static final String BUNDLE_SYMBOLIC_NAME_ATTRIBUTE = "Bundle-SymbolicName";
    private static final String BUNDLE_VERSION = ServiceFinder.getBundleAttribute("Bundle-Version");
    private static final String BUNDLE_SYMBOLIC_NAME = ServiceFinder.getBundleAttribute("Bundle-SymbolicName");
    private static final String MODULE_VERSION_VALUE = ServiceFinder.getModuleVersion();
    private final Class<T> serviceClass;
    private final String serviceName;
    private final ClassLoader classLoader;
    private final boolean ignoreOnClassNotFound;
    private static final Map<URL, Boolean> manifestURLs;

    private static String getBundleAttribute(String attributeName) {
        try {
            String version = ServiceFinder.getManifest(ServiceFinder.class).getMainAttributes().getValue(attributeName);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, String.format("ServiceFinder %s: %s", attributeName, version));
            }
            return version;
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Error loading META-INF/MANIFEST.MF associated with " + ServiceFinder.class.getName(), ex);
            return null;
        }
    }

    private static String getModuleVersion() {
        try {
            String resource = ServiceFinder.class.getName().replace(".", "/") + ".class";
            URL url = ServiceFinder.getResource(ServiceFinder.class.getClassLoader(), resource);
            if (url == null) {
                LOGGER.log(Level.FINE, "Error getting {0} class as a resource", ServiceFinder.class.getName());
                return null;
            }
            return ServiceFinder.getJerseyModuleVersion(ServiceFinder.getManifestURL(resource, url));
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error loading META-INF/jersey-module-version associated with " + ServiceFinder.class.getName(), ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Enumeration<URL> filterServiceURLsWithVersion(String serviceName, Enumeration<URL> serviceUrls) {
        if (BUNDLE_VERSION == null || !serviceUrls.hasMoreElements()) {
            return serviceUrls;
        }
        ArrayList<URL> urls = Collections.list(serviceUrls);
        ListIterator li = urls.listIterator();
        while (li.hasNext()) {
            URL url = (URL)li.next();
            try {
                URL manifestURL = ServiceFinder.getManifestURL(serviceName, url);
                Map<URL, Boolean> map = manifestURLs;
                synchronized (map) {
                    Boolean keep = manifestURLs.get(manifestURL);
                    if (keep != null) {
                        if (!keep.booleanValue()) {
                            if (LOGGER.isLoggable(Level.CONFIG)) {
                                LOGGER.log(Level.CONFIG, "Ignoring service URL: {0}", url);
                            }
                            li.remove();
                        } else if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Including service URL: {0}", url);
                        }
                    } else if (!ServiceFinder.compatibleManifest(manifestURL)) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.log(Level.CONFIG, "Ignoring service URL: {0}", url);
                        }
                        li.remove();
                        manifestURLs.put(manifestURL, false);
                    } else {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Including service URL: {0}", url);
                        }
                        manifestURLs.put(manifestURL, true);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, "Error loading META-INF/MANIFEST.MF associated with " + url, ex);
            }
        }
        return Collections.enumeration(urls);
    }

    private static boolean compatibleManifest(URL manifestURL) throws IOException {
        Attributes as = ServiceFinder.getManifest(manifestURL).getMainAttributes();
        String symbolicName = as.getValue(BUNDLE_SYMBOLIC_NAME_ATTRIBUTE);
        String version = as.getValue(BUNDLE_VERSION_ATTRIBUTE);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Checking META-INF/MANIFEST.MF URL: {0}\n  Bundle-SymbolicName: {1}\n  Bundle-Version: {2}", new Object[]{manifestURL, symbolicName, version});
        }
        if (symbolicName != null && symbolicName.startsWith("com.sun.jersey") && !BUNDLE_VERSION.equals(version)) {
            return false;
        }
        String moduleVersion = ServiceFinder.getJerseyModuleVersion(manifestURL);
        return moduleVersion == null || moduleVersion.equals(MODULE_VERSION_VALUE) && (symbolicName == null || !(BUNDLE_SYMBOLIC_NAME.startsWith("com.sun.jersey") ^ symbolicName.startsWith("com.sun.jersey")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getJerseyModuleVersion(URL manifestURL) {
        BufferedReader reader = null;
        try {
            URL moduleVersionURL = new URL(manifestURL.toString().replace(MANIFEST, MODULE_VERSION));
            reader = new BufferedReader(new InputStreamReader(moduleVersionURL.openStream()));
            String string = reader.readLine();
            return string;
        }
        catch (IOException ioe) {
            LOGGER.log(Level.FINE, "Error loading META-INF/jersey-module-version associated with " + ServiceFinder.class.getName(), ioe);
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ServiceFinder.class.getName()).log(Level.FINE, "Error closing manifest located at URL: " + manifestURL, ex);
                }
            }
        }
    }

    private static Manifest getManifest(Class c) throws IOException {
        String resource = c.getName().replace(".", "/") + ".class";
        URL url = ServiceFinder.getResource(c.getClassLoader(), resource);
        if (url == null) {
            throw new IOException("Resource not found: " + resource);
        }
        return ServiceFinder.getManifest(resource, url);
    }

    private static Manifest getManifest(String name, URL serviceURL) throws IOException {
        return ServiceFinder.getManifest(ServiceFinder.getManifestURL(name, serviceURL));
    }

    private static URL getManifestURL(String name, URL serviceURL) throws IOException {
        return new URL(serviceURL.toString().replace(name, MANIFEST));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest getManifest(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        finally {
            in.close();
        }
    }

    private static URL getResource(ClassLoader loader, String name) throws IOException {
        if (loader == null) {
            return ServiceFinder.getResource(name);
        }
        URL resource = loader.getResource(name);
        if (resource != null) {
            return resource;
        }
        return ServiceFinder.getResource(name);
    }

    private static URL getResource(String name) throws IOException {
        if (ServiceFinder.class.getClassLoader() != null) {
            return ServiceFinder.class.getClassLoader().getResource(name);
        }
        return ClassLoader.getSystemResource(name);
    }

    private static Enumeration<URL> getResources(ClassLoader loader, String name) throws IOException {
        if (loader == null) {
            return ServiceFinder.getResources(name);
        }
        Enumeration<URL> resources = loader.getResources(name);
        if (resources != null && resources.hasMoreElements()) {
            return resources;
        }
        return ServiceFinder.getResources(name);
    }

    private static Enumeration<URL> getResources(String name) throws IOException {
        if (ServiceFinder.class.getClassLoader() != null) {
            return ServiceFinder.class.getClassLoader().getResources(name);
        }
        return ClassLoader.getSystemResources(name);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader) throws ServiceConfigurationError {
        return ServiceFinder.find(service, loader, false);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) throws ServiceConfigurationError {
        return new ServiceFinder<T>(service, loader, ignoreOnClassNotFound);
    }

    public static <T> ServiceFinder<T> find(Class<T> service) throws ServiceConfigurationError {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader(), false);
    }

    public static <T> ServiceFinder<T> find(Class<T> service, boolean ignoreOnClassNotFound) throws ServiceConfigurationError {
        return ServiceFinder.find(service, Thread.currentThread().getContextClassLoader(), ignoreOnClassNotFound);
    }

    public static ServiceFinder<?> find(String serviceName) throws ServiceConfigurationError {
        return new ServiceFinder<Object>(Object.class, serviceName, Thread.currentThread().getContextClassLoader(), false);
    }

    public static void setIteratorProvider(ServiceIteratorProvider sip) throws SecurityException {
        ServiceIteratorProvider.setInstance(sip);
    }

    private ServiceFinder(Class<T> service, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this(service, service.getName(), loader, ignoreOnClassNotFound);
    }

    private ServiceFinder(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
        this.serviceClass = service;
        this.serviceName = serviceName;
        this.classLoader = loader;
        this.ignoreOnClassNotFound = ignoreOnClassNotFound;
    }

    @Override
    public Iterator<T> iterator() {
        return ServiceIteratorProvider.getInstance().createIterator(this.serviceClass, this.serviceName, this.classLoader, this.ignoreOnClassNotFound);
    }

    private Iterator<Class<T>> classIterator() {
        return ServiceIteratorProvider.getInstance().createClassIterator(this.serviceClass, this.serviceName, this.classLoader, this.ignoreOnClassNotFound);
    }

    public T[] toArray() throws ServiceConfigurationError {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : this) {
            result.add(t);
        }
        return result.toArray((Object[])Array.newInstance(this.serviceClass, result.size()));
    }

    public Class<T>[] toClassArray() throws ServiceConfigurationError {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        Iterator<Class<T>> i = this.classIterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
        return result.toArray((Class[])Array.newInstance(Class.class, result.size()));
    }

    private static void fail(String serviceName, String msg, Throwable cause) throws ServiceConfigurationError {
        ServiceConfigurationError sce = new ServiceConfigurationError(serviceName + ": " + msg);
        sce.initCause(cause);
        throw sce;
    }

    private static void fail(String serviceName, String msg) throws ServiceConfigurationError {
        throw new ServiceConfigurationError(serviceName + ": " + msg);
    }

    private static void fail(String serviceName, URL u, int line, String msg) throws ServiceConfigurationError {
        ServiceFinder.fail(serviceName, u + ":" + line + ": " + msg);
    }

    private static int parseLine(String serviceName, URL u, BufferedReader r, int lc, List<String> names, Set<String> returned) throws IOException, ServiceConfigurationError {
        int n;
        String ln = r.readLine();
        if (ln == null) {
            return -1;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((n = (ln = ln.trim()).length()) != 0) {
            int cp;
            if (ln.indexOf(32) >= 0 || ln.indexOf(9) >= 0) {
                ServiceFinder.fail(serviceName, u, lc, LocalizationMessages.ILLEGAL_CONFIG_SYNTAX());
            }
            if (!Character.isJavaIdentifierStart(cp = ln.codePointAt(0))) {
                ServiceFinder.fail(serviceName, u, lc, LocalizationMessages.ILLEGAL_PROVIDER_CLASS_NAME(ln));
            }
            for (int i = Character.charCount(cp); i < n; i += Character.charCount(cp)) {
                cp = ln.codePointAt(i);
                if (Character.isJavaIdentifierPart(cp) || cp == 46) continue;
                ServiceFinder.fail(serviceName, u, lc, LocalizationMessages.ILLEGAL_PROVIDER_CLASS_NAME(ln));
            }
            if (!returned.contains(ln)) {
                names.add(ln);
                returned.add(ln);
            }
        }
        return lc + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterator<String> parse(String serviceName, URL u, Set<String> returned) throws ServiceConfigurationError {
        InputStream in = null;
        BufferedReader r = null;
        ArrayList<String> names = new ArrayList<String>();
        try {
            URLConnection uConn = u.openConnection();
            uConn.setUseCaches(false);
            in = uConn.getInputStream();
            r = new BufferedReader(new InputStreamReader(in, "utf-8"));
            int lc = 1;
            while ((lc = ServiceFinder.parseLine(serviceName, u, r, lc, names, returned)) >= 0) {
            }
        }
        catch (IOException x) {
            ServiceFinder.fail(serviceName, ": " + x);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException y) {
                ServiceFinder.fail(serviceName, ": " + y);
            }
        }
        return names.iterator();
    }

    static {
        OsgiRegistry osgiRegistry = ReflectionHelper.getOsgiRegistryInstance();
        if (osgiRegistry != null) {
            LOGGER.log(Level.CONFIG, "Running in an OSGi environment");
            osgiRegistry.hookUp();
        } else {
            LOGGER.log(Level.CONFIG, "Running in a non-OSGi environment");
        }
        manifestURLs = new HashMap<URL, Boolean>();
    }

    public static final class DefaultServiceIteratorProvider
    extends ServiceIteratorProvider {
        @Override
        public <T> Iterator<T> createIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            return new LazyObjectIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public <T> Iterator<Class<T>> createClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            return new LazyClassIterator(service, serviceName, loader, ignoreOnClassNotFound);
        }
    }

    public static abstract class ServiceIteratorProvider {
        private static volatile ServiceIteratorProvider sip;
        private static final Object sipLock;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ServiceIteratorProvider getInstance() {
            ServiceIteratorProvider result = sip;
            if (result == null) {
                Object object = sipLock;
                synchronized (object) {
                    result = sip;
                    if (result == null) {
                        sip = result = new DefaultServiceIteratorProvider();
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void setInstance(ServiceIteratorProvider sip) throws SecurityException {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                ReflectPermission rp = new ReflectPermission("suppressAccessChecks");
                security.checkPermission(rp);
            }
            Object object = sipLock;
            synchronized (object) {
                ServiceIteratorProvider.sip = sip;
            }
        }

        public abstract <T> Iterator<T> createIterator(Class<T> var1, String var2, ClassLoader var3, boolean var4);

        public abstract <T> Iterator<Class<T>> createClassIterator(Class<T> var1, String var2, ClassLoader var3, boolean var4);

        static {
            sipLock = new Object();
        }
    }

    private static final class LazyObjectIterator<T>
    extends AbstractLazyIterator<T>
    implements Iterator<T> {
        private T t;

        private LazyObjectIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            super(service, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            this.setConfigs();
            while (this.nextName == null) {
                while (this.pending == null || !this.pending.hasNext()) {
                    if (!this.configs.hasMoreElements()) {
                        return false;
                    }
                    this.pending = ServiceFinder.parse(this.serviceName, (URL)this.configs.nextElement(), this.returned);
                }
                this.nextName = (String)this.pending.next();
                try {
                    this.t = this.service.cast(ReflectionHelper.classForNameWithException(this.nextName, this.loader).newInstance());
                }
                catch (ClassNotFoundException ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, LocalizationMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.serviceName, LocalizationMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                }
                catch (NoClassDefFoundError ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.log(Level.CONFIG, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.serviceName, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service), ex);
                }
                catch (ClassFormatError ex) {
                    if (this.ignoreOnClassNotFound) {
                        if (LOGGER.isLoggable(Level.CONFIG)) {
                            LOGGER.log(Level.CONFIG, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service));
                        }
                        this.nextName = null;
                        continue;
                    }
                    ServiceFinder.fail(this.serviceName, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service), ex);
                }
                catch (Exception ex) {
                    ServiceFinder.fail(this.serviceName, LocalizationMessages.PROVIDER_COULD_NOT_BE_CREATED(this.nextName, this.service, ex.getLocalizedMessage()), ex);
                }
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            return this.t;
        }
    }

    private static final class LazyClassIterator<T>
    extends AbstractLazyIterator<T>
    implements Iterator<Class<T>> {
        private LazyClassIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            super(service, serviceName, loader, ignoreOnClassNotFound);
        }

        @Override
        public Class<T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String cn = this.nextName;
            this.nextName = null;
            try {
                return ReflectionHelper.classForNameWithException(cn, this.loader);
            }
            catch (ClassNotFoundException ex) {
                ServiceFinder.fail(this.serviceName, LocalizationMessages.PROVIDER_NOT_FOUND(cn, this.service));
            }
            catch (NoClassDefFoundError ex) {
                ServiceFinder.fail(this.serviceName, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), cn, this.service));
            }
            catch (ClassFormatError ex) {
                ServiceFinder.fail(this.serviceName, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), cn, this.service));
            }
            catch (Exception x) {
                ServiceFinder.fail(this.serviceName, LocalizationMessages.PROVIDER_CLASS_COULD_NOT_BE_LOADED(cn, this.service, x.getLocalizedMessage()), x);
            }
            return null;
        }
    }

    private static class AbstractLazyIterator<T> {
        final Class<T> service;
        final String serviceName;
        final ClassLoader loader;
        final boolean ignoreOnClassNotFound;
        Enumeration<URL> configs = null;
        Iterator<String> pending = null;
        Set<String> returned = new TreeSet<String>();
        String nextName = null;

        private AbstractLazyIterator(Class<T> service, String serviceName, ClassLoader loader, boolean ignoreOnClassNotFound) {
            this.service = service;
            this.serviceName = serviceName;
            this.loader = loader;
            this.ignoreOnClassNotFound = ignoreOnClassNotFound;
        }

        protected final void setConfigs() {
            if (this.configs == null) {
                try {
                    String fullName = ServiceFinder.PREFIX + this.serviceName;
                    this.configs = ServiceFinder.filterServiceURLsWithVersion(fullName, ServiceFinder.getResources(this.loader, fullName));
                }
                catch (IOException x) {
                    ServiceFinder.fail(this.serviceName, ": " + x);
                }
            }
        }

        public boolean hasNext() throws ServiceConfigurationError {
            if (this.nextName != null) {
                return true;
            }
            this.setConfigs();
            while (this.nextName == null) {
                while (this.pending == null || !this.pending.hasNext()) {
                    if (!this.configs.hasMoreElements()) {
                        return false;
                    }
                    this.pending = ServiceFinder.parse(this.serviceName, this.configs.nextElement(), this.returned);
                }
                this.nextName = this.pending.next();
                if (!this.ignoreOnClassNotFound) continue;
                try {
                    ReflectionHelper.classForNameWithException(this.nextName, this.loader);
                }
                catch (ClassNotFoundException ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, LocalizationMessages.PROVIDER_NOT_FOUND(this.nextName, this.service));
                    }
                    this.nextName = null;
                }
                catch (NoClassDefFoundError ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_NOT_FOUND(ex.getLocalizedMessage(), this.nextName, this.service));
                    }
                    this.nextName = null;
                }
                catch (ClassFormatError ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, LocalizationMessages.DEPENDENT_CLASS_OF_PROVIDER_FORMAT_ERROR(ex.getLocalizedMessage(), this.nextName, this.service));
                    }
                    this.nextName = null;
                }
            }
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

