/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Feature;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.CustomAnnotationImpl;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ScopedBindingBuilder;
import org.glassfish.jersey.model.ContractProvider;
import org.glassfish.jersey.model.internal.FeatureBag;
import org.glassfish.jersey.model.internal.FeatureConfig;
import org.glassfish.jersey.model.internal.ProviderBag;

public class ProviderBinder {
    private final ServiceLocator locator;

    public ProviderBinder(ServiceLocator locator) {
        this.locator = locator;
    }

    public void bindInstances(Iterable<Object> instances) {
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Object instance : instances) {
            this.bindInstance(instance, dc);
        }
        dc.commit();
    }

    public void bindClasses(Class<?> ... classes) {
        if (classes != null && classes.length > 0) {
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            for (Class<?> clazz : classes) {
                this.bindClass(clazz, this.locator, dc, false);
            }
            dc.commit();
        }
    }

    public void bindClasses(Iterable<Class<?>> classes) {
        this.bindClasses(classes, false);
    }

    public void bindClasses(Iterable<Class<?>> classes, boolean bindResources) {
        if (classes == null || !classes.iterator().hasNext()) {
            return;
        }
        DynamicConfiguration dc = Injections.getConfiguration(this.locator);
        for (Class<?> clazz : classes) {
            this.bindClass(clazz, this.locator, dc, bindResources);
        }
        dc.commit();
    }

    public static void bindProvider(Class<?> providerClass, ContractProvider provider, DynamicConfiguration dc) {
        for (Class<?> contract : provider.getContracts()) {
            ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(providerClass).in(provider.getScope()).qualifiedBy(new CustomAnnotationImpl());
            bindingBuilder.to(contract);
            int priority = provider.getPriority(contract);
            if (priority > -1) {
                bindingBuilder.ranked(priority);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    public static void bindProvider(Object providerInstance, ContractProvider provider, DynamicConfiguration dc) {
        for (Class<?> contract : provider.getContracts()) {
            ScopedBindingBuilder<Object> bindingBuilder = Injections.newBinder(providerInstance).qualifiedBy(new CustomAnnotationImpl());
            bindingBuilder.to(contract);
            int priority = provider.getPriority(contract);
            if (priority > -1) {
                bindingBuilder.ranked(priority);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    public static void bindProviders(ProviderBag providerBag, ServiceLocator locator) {
        ProviderBinder.bindProviders(providerBag, null, Collections.<Class<?>>emptySet(), locator);
    }

    public static void bindProviders(ProviderBag providerBag, ConstrainedTo.Type constrainedTo, Set<Class<?>> registeredClasses, ServiceLocator locator) {
        DynamicConfiguration dc = Injections.getConfiguration(locator);
        ProviderBinder.bindProviders(providerBag, constrainedTo, registeredClasses, dc);
        dc.commit();
    }

    public static void bindProviders(ProviderBag providerBag, ConstrainedTo.Type constrainedTo, Set<Class<?>> registeredClasses, DynamicConfiguration dynamicConfiguration) {
        Set<Object> classes = Sets.newLinkedHashSet(providerBag.getClasses());
        if (constrainedTo != null) {
            classes = Providers.filterByConstraint(classes, constrainedTo, registeredClasses);
        }
        for (Class providerClass : classes) {
            ContractProvider model = providerBag.getModels().get(providerClass);
            ProviderBinder.bindProvider(providerClass, model, dynamicConfiguration);
        }
        Set<Object> instances = providerBag.getInstances();
        if (constrainedTo != null) {
            instances = Providers.filterInstancesByConstraint(instances, constrainedTo, registeredClasses);
        }
        for (Object provider : instances) {
            ContractProvider model = providerBag.getModels().get(provider.getClass());
            ProviderBinder.bindProvider(provider, model, dynamicConfiguration);
        }
    }

    public static void configureFeatures(FeatureBag featureBag, Configurable configuration, ServiceLocator locator) {
        ProviderBinder.configureFeatures(featureBag, featureBag.getUnconfiguredFeatures(), Sets.newHashSet(), configuration, locator);
    }

    private static void configureFeatures(FeatureBag featureBag, Collection<FeatureBag.RegisteredFeature> unprocessed, Collection<FeatureBag.RegisteredFeature> processed, Configurable configuration, ServiceLocator locator) {
        for (FeatureBag.RegisteredFeature registeredFeature : unprocessed) {
            Feature feature = registeredFeature.getFeature();
            if (feature == null) {
                feature = (Feature)locator.create(registeredFeature.getFeatureClass());
            } else {
                locator.inject((Object)feature);
            }
            if (featureBag.isEnabled(feature) || processed.contains(registeredFeature)) {
                throw new IllegalStateException(LocalizationMessages.FEATURE_HAS_ALREADY_BEEN_ENABLED(feature));
            }
            FeatureConfig featureConfig = new FeatureConfig(configuration);
            boolean success = feature.configure((Configurable)featureConfig);
            if (!success) continue;
            processed.add(registeredFeature);
            ProviderBinder.configureFeatures(featureBag, featureConfig.getUnprocessedFeatures(), processed, configuration, locator);
            if (!featureBag.isRegistered(registeredFeature)) continue;
            featureBag.setEnabled(feature);
        }
    }

    private <T> void bindInstance(T instance, DynamicConfiguration dc) {
        for (Class<?> contract : Providers.getProviderContracts(instance.getClass())) {
            Injections.addBinding(Injections.newBinder(instance).to(contract).qualifiedBy(new CustomAnnotationImpl()), dc);
        }
    }

    private <T> void bindClass(Class<T> clazz, ServiceLocator locator, DynamicConfiguration dc, boolean isResource) {
        Class<? extends Annotation> scope = this.getProviderScope(clazz);
        if (isResource) {
            ActiveDescriptor descriptor = dc.bind((Descriptor)BuilderHelper.activeLink(clazz).to(clazz).in(scope).build());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                AliasDescriptor aliasDescriptor = new AliasDescriptor(locator, descriptor, contract.getName(), null);
                aliasDescriptor.setScope(scope.getName());
                aliasDescriptor.addQualifierAnnotation((Annotation)new CustomAnnotationImpl());
                dc.bind((Descriptor)aliasDescriptor);
            }
        } else {
            ScopedBindingBuilder<?> bindingBuilder = Injections.newBinder(clazz).in(scope).qualifiedBy(new CustomAnnotationImpl());
            for (Class<?> contract : Providers.getProviderContracts(clazz)) {
                bindingBuilder.to(contract);
            }
            Injections.addBinding(bindingBuilder, dc);
        }
    }

    private Class<? extends Annotation> getProviderScope(Class<?> clazz) {
        Class<Singleton> hk2Scope = Singleton.class;
        if (clazz.isAnnotationPresent(PerLookup.class)) {
            hk2Scope = PerLookup.class;
        }
        return hk2Scope;
    }
}

