/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.NameBinding;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.NameBound;
import org.glassfish.jersey.model.Scoped;

public final class ContractProvider
implements Scoped,
NameBound {
    public static final int NO_PRIORITY = -1;
    private final Map<Class<?>, Integer> contracts;
    private final int defaultPriority;
    private final Set<Class<? extends Annotation>> nameBindings;
    private final Class<? extends Annotation> scope;

    public static ContractProvider from(Class<?> serviceClass) {
        return ContractProvider.from(serviceClass, -1, null);
    }

    public static ContractProvider from(Class<?> serviceClass, int bindingPriority, Set<Class<?>> contracts) {
        Builder builder = ContractProvider.builder();
        if ((contracts == null || contracts.isEmpty()) && (contracts = Providers.getProviderContracts(serviceClass)).isEmpty()) {
            return null;
        }
        if (bindingPriority > -1) {
            builder.defaultPriority(bindingPriority);
        }
        for (Annotation annotation : serviceClass.getAnnotations()) {
            if (annotation instanceof BindingPriority) {
                if (bindingPriority != -1) continue;
                builder.defaultPriority(((BindingPriority)annotation).value());
                continue;
            }
            for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                if (metaAnnotation instanceof NameBinding) {
                    builder.addNameBinding(annotation.annotationType());
                }
                if (!(metaAnnotation instanceof Scope)) continue;
                builder.scope(annotation.annotationType());
            }
        }
        builder.addContracts(contracts);
        return builder.build();
    }

    public static ContractProvider from(Object service) {
        return ContractProvider.from(service.getClass());
    }

    public static ContractProvider from(Object service, int bindingPriority, Set<Class<?>> contracts) {
        return ContractProvider.from(service.getClass(), bindingPriority, contracts);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ContractProvider original) {
        return new Builder(original);
    }

    private ContractProvider(Class<? extends Annotation> scope, Map<Class<?>, Integer> contracts, int defaultPriority, Set<Class<? extends Annotation>> nameBindings) {
        this.scope = scope;
        this.contracts = contracts;
        this.defaultPriority = defaultPriority;
        this.nameBindings = nameBindings;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public Set<Class<?>> getContracts() {
        return this.contracts.keySet();
    }

    @Override
    public boolean isNameBound() {
        return !this.nameBindings.isEmpty();
    }

    public int getPriority(Class<?> contract) {
        return this.contracts.containsKey(contract) ? this.contracts.get(contract) : this.defaultPriority;
    }

    public Set<Class<? extends Annotation>> getNameBindings() {
        return this.nameBindings;
    }

    public static final class Builder {
        private Class<? extends Annotation> scope = Singleton.class;
        private Map<Class<?>, Integer> contracts = Maps.newHashMap();
        private int defaultPriority = -1;
        private Set<Class<? extends Annotation>> nameBindings = Sets.newIdentityHashSet();

        private Builder() {
        }

        private Builder(ContractProvider original) {
            this.scope = original.scope;
            this.contracts.putAll(original.contracts);
            this.defaultPriority = original.defaultPriority;
            this.nameBindings.addAll(original.nameBindings);
        }

        public Builder scope(Class<? extends Annotation> scope) {
            this.scope = scope;
            return this;
        }

        public Builder addContract(Class<?> contract) {
            return this.addContract(contract, this.defaultPriority);
        }

        public Builder addContract(Class<?> contract, int priority) {
            this.contracts.put(contract, priority);
            return this;
        }

        public Builder addContracts(Map<Class<?>, Integer> contracts) {
            this.contracts.putAll(contracts);
            return this;
        }

        public Builder addContracts(Collection<Class<?>> contracts) {
            for (Class<?> contract : contracts) {
                this.addContract(contract, this.defaultPriority);
            }
            return this;
        }

        public Builder defaultPriority(int defaultPriority) {
            this.defaultPriority = defaultPriority;
            return this;
        }

        public Builder addNameBinding(Class<? extends Annotation> binding) {
            this.nameBindings.add(binding);
            return this;
        }

        public ContractProvider build() {
            return new ContractProvider(this.scope, this.contracts, this.defaultPriority, this.nameBindings);
        }
    }
}

